% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vinereg.R
\name{vinereg}
\alias{vinereg}
\title{D-vine quantile regression}
\usage{
vinereg(formula, data, family_set = "parametric", selcrit = "loglik",
  order = NA, par_1d = list(), cores = 1, uscale = FALSE, ...)
}
\arguments{
\item{formula}{an object of class "formula"; same as \code{\link[=lm]{lm()}}.}

\item{data}{data frame (or object coercible by
\code{\link[=as.data.frame]{as.data.frame()}}) containing the variables in the model.}

\item{family_set}{see \code{family_set} argument of \code{\link[rvinecopulib:bicop]{rvinecopulib::bicop()}}.}

\item{selcrit}{selection criterion based on conditional log-likelihood.
\code{"loglik"} (default) imposes no correction; other choices are
\code{"aic"} and \code{"bic"}.}

\item{order}{the order of covariates in the D-vine, provided as vector
of variable names (after calling \code{cctools::cont_conv()} on the
\code{model.frame()}); selected automatically if \code{order = NA} (default).}

\item{par_1d}{list of options passed to \code{\link[kde1d:kde1d]{kde1d::kde1d()}}, must be one value
for each margin, e.g. \code{list(xmin = c(0, 0, -Inf))} if the response and
first covariate have non-negative support.}

\item{cores}{integer.}

\item{uscale}{logical indicating whether the data are already on copula scale
(no margins have to be fitted).}

\item{...}{further arguments passed to \code{\link[rvinecopulib:bicop]{rvinecopulib::bicop()}}.}
}
\value{
An object of class vinereg. It is a list containing the elements
\describe{
\item{margins}{list of marginal models fitted by \code{\link[kde1d:kde1d]{kde1d::kde1d()}}.}
\item{vine}{an \code{\link[rvinecopulib:vinecop_dist]{rvinecopulib::vinecop_dist()}} object containing the fitted
D-vine.}
\item{order}{order of the covariates chosen by the variable selection algorithm.}
\item{selected_vars}{indices of selected variables.}
\item{formula}{the model formula specified by the user.}
\item{model_frame}{the data used to fit the D-vine.}
}
This object can be plugged into \code{\link[=predict.vinereg]{predict.vinereg()}} to predict conditional
quantiles.
}
\description{
Sequential estimation of a regression D-vine for the purpose of quantile
prediction as described in Kraus and Czado (2017).
}
\examples{
# simulate data
x <- matrix(rnorm(300), 100, 3)
y <- x \%*\% c(1, -1, 2)
dat <- data.frame(y = y, x = x, z = as.factor(rbinom(100, 3, 0.5)))

# fit vine regression model (parametric)
fit <- vinereg(y ~ ., dat, family_set = "parametric")

# model predictions (median)
pred <- predict(fit, newdata = dat, alpha = 0.5)

# observed vs predicted
plot(cbind(y, pred))


## fixed variable order (no selection)
fit <- vinereg(y ~ ., dat, order = c("x.3", "x.1", "x.2", "z.1"))
fit$order

}
\references{
Kraus and Czado (2017), D-vine copula based quantile regression,
Computational Statistics and Data Analysis, 110, 1-18
}
\seealso{
\code{\link{predict.vinereg}}
}
