# vines: Multivariate Dependence Modeling with Vines
# Copyright (C) 2010, 2011 Yasser González-Fernández <ygf@icmf.inf.cu>
# Copyright (C) 2010, 2011 Marta Soto <mrosa@icmf.inf.cu>
#
# This program is free software: you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program. If not, see <http://www.gnu.org/licenses/>.

setGeneric("dvine",
        function (vine, u) standardGeneric("dvine"),
        signature = "vine")


dCVineDVine <- function (vine, u) {
    if (is.vector(u)) u <- matrix(u, nrow = 1)
    
    if (vine@trees == 0) {
        # The product of the uniform marginal densities.
        rep(1, nrow(u))
    } else {
        evalCopula <- function (vine, j, i, x, y) {
            dcopula(vine@copulas[[j, i]], cbind(x, y))
        }
        iterResult <- vineIter(vine, u, evalCopula = evalCopula)
        apply(matrix(unlist(iterResult$evals), nrow(u)), 1, prod)
    }
}

setMethod("dvine", "CVine", dCVineDVine)
setMethod("dvine", "DVine", dCVineDVine)
