% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_sparklines.R
\name{add_sparklines}
\alias{add_sparklines}
\alias{add_sparklines.vi}
\title{Add sparklines}
\usage{
add_sparklines(object, fit, digits = 3, free_y = FALSE,
  verbose = FALSE, ...)

\method{add_sparklines}{vi}(object, fit, digits = 3, free_y = FALSE,
  verbose = FALSE, ...)
}
\arguments{
\item{object}{An object that inherits from class \code{"vi"}.}

\item{fit}{The original fitted model. Only needed if `vi()` was not called
with `method = "pdp"` or `method = "ice"`.}

\item{digits}{Integer specifying the minimal number of significant digits to
use for displaying importance scores and, if available, their standard
deviations.}

\item{free_y}{Logical indicating whether or not the the y-axis limits should
be allowed to vary for each sparkline. Default is \code{FALSE}.}

\item{verbose}{Logical indicating whether or not to print progress. Default
is \code{FALSE}.}

\item{...}{Additional optional arguments to be passed onto
\code{\link[pdp]{partial}}.}
}
\value{
An object of class \code{c("datatables", "htmlwidget")}; essentially,
a data frame with three columns: \code{Variable}, \code{Importance}, and
\code{Effect} (a sparkline representation of the partial dependence
function). For \code{"lm"/"glm"}-like objects, an additional column, called
\code{Sign}, is also included which includes the sign (i.e., POS/NEG) of the
original coefficient.
}
\description{
Create an HTML widget to display variable importance scores with a sparkline
representation of each features effect (i.e., its partial dependence
function).
}
\references{
Greenwell, B. M., Boehmke, B. C., and McCarthy, A. J. A Simple
and Effective Model-Based Variable Importance Measure. arXiv preprint
arXiv:1805.04755 (2018).
}
