% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateDriverS.R
\name{simulateDriverS}
\alias{simulateDriverS}
\title{Generates drivers for \code{\link{simulatePopulation}}.}
\usage{
simulateDriverS(
 random.seeds=c(60, 120),
 time=1:10000,
 autocorrelation.lengths=c(200, 600),
 output.min=c(0,0),
 output.max=c(100, 100),
 driver.names=c("A", "B"),
 filename=NULL)
}
\arguments{
\item{random.seeds}{vector of integers, seeds to be used by \code{set.seed}.}

\item{time}{integer, or numeric vector of integers with constant intervals. If a single integer is provided, a time sequence is generated from 0 to the given integer as \emph{seq(0, time, by = 1)}. Default is 1:10000.}

\item{autocorrelation.lengths}{vector of integers, represents the lengths of the convolution filters to be used to impose a particular temporal structure on each driver. Default is 100, equivalent to a filter composed by a hundred of ones.}

\item{output.min}{numeric vector, minimum values of the output time series. Used as input for \strong{rescaleVector}. Default is 0.}

\item{output.max}{numeric vector, maximum values of the output time series. Used as input for \strong{rescaleVector}. Default is 100.}

\item{driver.names}{character vector, with labels to be used to identify the drivers.}

\item{filename}{character string, name of output pdf file. If NULL or empty, no pdf is produced.}
}
\value{
A long format dataframe (see dataset \code{\link{drivers}}) with the following columns:

\itemize{
  \item \emph{time}: integer.
  \item \emph{driver}: character, values are \code{A} and \code{B}
  \item \emph{autocorrelation.length}: numeric, default values are 200, 600, and 1800.
  \item \emph{value}: numeric, value of the driver for the given \emph{time}.
}
}
\description{
Wrapper of \code{simulateDriver} to generate several drivers with different autocorrelation lengths, and return a long format dataframe to be used as input for \code{\link{simulatePopulation}}. It also produces a plot of the generated drivers. \strong{Important}: note that the variable \code{time} runs from left to right, with lower values representing older samples.
}
\details{
It is recommended to use \code{time} vectors with a time step of 1 between consecutive values when the output is to be used as input for \code{\link{simulatePopulation}}, which considers annual time-steps while simulating virtual pollen curves. Initial random sequence is generated by \code{rnorm}. Desired temporal autocorrelation are approximate, but deviation becomes higher if \code{autocorrelation.length} is larger than half the length of \code{time}. Consequently, the function limits \code{autocorrelation.length} to \code{length(time)/2}.
}
\examples{

drivers <- simulateDriverS(
 random.seeds=c(60, 120),
 time=1:10000,
 autocorrelation.lengths=c(200, 600),
 output.min=c(0,0),
 output.max=c(100, 100),
 driver.names=c("A", "B"),
 filename=NULL
)

str(drivers)

}
\seealso{
\code{\link{drivers}}, \code{\link{simulateDriver}}, \code{\link{simulatePopulation}}, \code{\link{drivers}}
}
\author{
Blas M. Benito  <blasbenito@gmail.com>
}
