% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visClustering.R
\name{visClusteringByColor}
\alias{visClusteringByColor}
\title{Network visualization clustering options - by color}
\usage{
visClusteringByColor(graph, colors, label = "Cluster on color : ",
  shape = "database", force = FALSE)
}
\arguments{
\item{graph}{: a visNetwork object}

\item{colors}{: Character/vector. colors we want to cluster}

\item{label}{: Character. Label put before value(s). See example}

\item{shape}{: Character. Shape of cluster(s) if different shapes between nodes or \code{force = T}. "database" per default}

\item{force}{: If \code{force = FALSE}, Set shape of nodes if all equal, else directly defaut shape}
}
\description{
Network visualization clustering options - by color.
}
\examples{

set.seed(124)
nodes <- data.frame(id = 1:10, color = c(rep("blue", 6), rep("red", 3), rep("green", 1)))
edges <- data.frame(from = round(runif(6)*10), to = round(runif(6)*10))

visNetwork(nodes, edges) \%>\%
 visClusteringByColor(colors = c("blue"))
 
 nodes <- data.frame(id = 1:10, label = paste("Label", 1:10), 
   group = sample(c("A", "B"), 10, replace = TRUE))
 edges <- data.frame(from = c(2,5,10), to = c(1,2,10))

 visNetwork(nodes, edges, legend = TRUE) \%>\%
   visGroups(groupname = "A", color = "red", shape = "square") \%>\%
   visGroups(groupname = "B", color = "yellow", shape = "triangle") \%>\%
   visClusteringByColor(colors = c("red"), label = "With color ") \%>\%
   visClusteringByGroup(groups = c("B"), label = "Group : ")
   
 visNetwork(nodes, edges, legend = TRUE) \%>\%
   visGroups(groupname = "A", color = "red", shape = "triangle") \%>\%
   visGroups(groupname = "B", color = "yellow", shape = "triangle") \%>\%
   visClusteringByGroup(groups = c("A","B"))
}

