% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatHeader.R
\name{formatHeader}
\alias{formatHeader}
\title{Creates a tibble with trageted rows pivotted into columns with header-ready
names to get formatted tables (gt or flextable)}
\usage{
formatHeader(
  result,
  header,
  delim = "\\n",
  includeHeaderName = TRUE,
  includeHeaderKey = TRUE
)
}
\arguments{
\item{result}{A summarised_result.}

\item{header}{Names of the columns to make headers. Names that doesn't
correspnd to a column of the table result, will be used as headers at the
defined position.}

\item{delim}{Delimiter to use to separate headers.}

\item{includeHeaderName}{Whether to include the column name as header.}

\item{includeHeaderKey}{Whether to include the header key (header,
header_name, header_level) before each header type in the column names.}
}
\value{
A tibble with rows pivotted into columns with key names for
subsequent header formatting.
}
\description{
Pivots a summarised_result object based on the column names in header,
generating specific column names for subsequent header formatting in
gtTable and fxTable functions.
}
\examples{
result <- mockSummarisedResult()

result |>
  formatHeader(
    header = c(
      "Study cohorts", "group_level", "Study strata", "strata_name",
      "strata_level"
    ),
    includeHeaderName = FALSE
  )
}
