% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vistime-package.R, R/vistime.R
\docType{package}
\name{vistime}
\alias{vistime}
\alias{vistime-package}
\title{vistime}
\usage{
vistime(data, events = "event", start = "start", end = "end",
  groups = "group", colors = "color", fontcolors = "fontcolor",
  tooltips = "tooltip", linewidth = NULL, title = NULL,
  showLabels = TRUE, lineInterval = NULL)
}
\arguments{
\item{data}{data.frame that contains the data to be visualised}

\item{events}{(optional) the column name in \code{data} that contains event names. Default: \emph{event}.}

\item{start}{(optional) the column name in \code{data} that contains start dates. Default: \emph{start}.}

\item{end}{(optional) the column name in \code{data} that contains end dates. Default: \emph{end}.}

\item{groups}{(optional) the column name in \code{data} to be used for grouping. Default: \emph{group}.}

\item{colors}{(optional) the column name in \code{data} that contains colors for events. Default: \emph{color}, if not present, colors are chosen via \code{RColorBrewer}.}

\item{fontcolors}{(optional) the column name in \code{data} that contains the font color for event labels. Default: \emph{fontcolor}, if not present, color will be black.}

\item{tooltips}{(optional) the column name in \code{data} that contains the mouseover tooltips for the events. Default: \emph{tooltip}, if not present, then tooltips are build from event name and date.}

\item{linewidth}{(optional) the linewidth for the events (typically used for large amount of parallel events). Default: heuristic value.}

\item{title}{(optional) the title to be shown on top of the timeline. Default: \code{NULL}.}

\item{showLabels}{(optional) choose whether or not event labels shall be visible. Default: \code{TRUE}.}

\item{lineInterval}{(optional) the distance of vertical lines (in \emph{seconds}) to demonstrate structure (default: heuristic, depending on total range). Default: heuristic value.}
}
\value{
\code{vistime} returns an object of class \code{plotly} and \code{htmlwidget}.
}
\description{
Create interactive and offline timelines using the \code{plotly.js} framework.
}
\examples{
# presidents and vice presidents
pres <- data.frame(Position = rep(c("President", "Vice"), each = 3),
                  Name = c("Washington", rep(c("Adams", "Jefferson"), 2), "Burr"),
                  start = c("1789-03-29", "1797-02-03", "1801-02-03"),
                  end = c("1797-02-03", "1801-02-03", "1809-02-03"),
                  color = c('#cbb69d', '#603913', '#c69c6e'),
                  fontcolor = c("black", "white", "black"))

vistime(pres, events="Position", groups="Name", title="Presidents of the USA",
              lineInterval = 60*60*24*365*5)

# more complex and colorful example
data <- read.csv(text="event,group,start,end,color
Phase 1,Project,2016-12-22,2016-12-23,#c8e6c9
Phase 2,Project,2016-12-23,2016-12-29,#a5d6a7
Phase 3,Project,2016-12-29,2017-01-06,#fb8c00
Phase 4,Project,2017-01-06,2017-02-02,#DD4B39
1-217.0,category 2,2016-12-27,2016-12-27,#90caf9
3-200,category 1,2016-12-25,2016-12-25,#1565c0
3-330,category 1,2016-12-25,2016-12-25,#1565c0
3-223,category 1,2016-12-28,2016-12-28,#1565c0
3-225,category 1,2016-12-28,2016-12-28,#1565c0
3-226,category 1,2016-12-28,2016-12-28,#1565c0
3-226,category 1,2017-01-19,2017-01-19,#1565c0
3-330,category 1,2017-01-19,2017-01-19,#1565c0
3-399.7,moon rising,2017-01-13,2017-01-13,#f44336
8-831.0,sundowner drink,2017-01-17,2017-01-17,#8d6e63
9-984.1,birthday party,2016-12-22,2016-12-22,#90a4ae
F01.9,Meetings,2016-12-26,2016-12-26,#e8a735
Z71,Meetings,2017-01-12,2017-01-12,#e8a735
B95.7,Meetings,2017-01-15,2017-01-15,#e8a735
T82.7,Meetings,2017-01-15,2017-01-15,#e8a735
Room 334,Team 1,2016-12-22,2016-12-28,#DEEBF7
Room 335,Team 1,2016-12-28,2017-01-05,#C6DBEF
Room 335,Team 1,2017-01-05,2017-01-23,#9ECAE1
Group 1,Team 2,2016-12-22,2016-12-28,#E5F5E0
Group 2,Team 2,2016-12-28,2017-01-23,#C7E9C0")

vistime(data)
}
\author{
Sandro Raabe \email{shosaco_nospam@hotmail.com}
}
\keyword{gantt}
\keyword{plotly}
\keyword{timeline}
\keyword{vistime}
