% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_input.R
\name{validate_input}
\alias{validate_input}
\title{Validate input data}
\usage{
validate_input(data, start, end, events, groups, linewidth, title,
  showLabels, show_labels, lineInterval, background_lines)
}
\arguments{
\item{data}{the data}

\item{start}{start dates}

\item{end}{end dates}

\item{events}{event column name}

\item{groups}{group column name}

\item{linewidth}{width of range lines}

\item{title}{plot title}

\item{showLabels}{deprecated, replaced by show_labels}

\item{show_labels}{boolean}

\item{lineInterval}{deprecated, replaced by background_lines}

\item{background_lines}{interval of grey background lines}
}
\value{
the data frame with possibly new or renamed columns, or an error
}
\description{
Validate input data
}
\examples{
\dontrun{
validate_input(data.frame(event = 1:2, start = c("2019-01-01", "2019-01-10")),
  events = "event", start = "start", end = "end", groups = "group",
  linewidth = NULL, title = NULL, showLabels = NULL, show_labels = TRUE,
  lineInterval = NULL, background_lines = 11
)
}
}
