% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nv.R
\name{nvgenerate}
\alias{nvgenerate}
\alias{agelm}
\alias{tddef}
\alias{ghdef}
\alias{pddef}
\alias{lutdef}
\alias{gdef}
\alias{lutgdef}
\title{Normative values generation and management}
\usage{
nvgenerate(
  vf,
  method = "pointwise",
  probs = c(0, 0.005, 0.01, 0.02, 0.05, 0.95, 0.98, 0.99, 0.995, 1),
  name = "",
  perimetry = "static automated perimetry",
  strategy = "",
  size = "",
  agem = agelm(vf),
  tdfun = tddef(agem),
  ghfun = ghdef(0.85),
  pdfun = pddef(ghfun)
)

agelm(vf)

tddef(agem)

ghdef(perc = 0.85)

pddef(ghfun = ghdef(0.85))

lutdef(vf, probs, type = "quantile", ...)

gdef(agem, sdtd, sdpd)

lutgdef(g, probs, type = "quantile", ...)
}
\arguments{
\item{vf}{visual field data with sensitivity values}

\item{method}{method to generate normative values, pointwise (`\code{pointwise}`)
or smoothed with 2-dimensional quadratic functions (`\code{smooth}`)}

\item{probs}{numeric vector of probabilities with values in \code{[0,1]}.
The values 0 and 1 must be included}

\item{name}{name for the normative values, e.g., "SUNY-IU pointwise NVs".
Default is blank}

\item{perimetry}{perimetry used to obtain normative data, e.g.,
"static automated perimetry" (default)}

\item{strategy}{psychophysical strategy used to obtain threshold values, e.g.,
"SITA standard". Default is blank}

\item{size}{stimulus size, if the same size was used for all visual field
locations or empty (default)}

\item{agem}{age model to construct the function to obtain TD values}

\item{tdfun}{Function for the calculation of total deviation maps}

\item{ghfun}{function used for determination of the GH and PD values}

\item{pdfun}{Function for the calculation of pattern deviation maps}

\item{perc}{the percentile to obtain the ranked TD value as
reference for the general height (GH) of the visual field.
Default is the 85th percentile, thus \code{0.85}}

\item{type}{type of estimation for the weighted quantile values. See
\code{wtd.quantile} for details. Default is `\code{quantile}`}

\item{...}{arguments to be passed to or from methods}

\item{sdtd}{standard deviations obtained for TD values}

\item{sdpd}{standard deviations obtained for PD values}

\item{g}{a table with global indices}
}
\value{
\code{nvgenerate} returns a list with normative values

\code{agelm} returns a list with coefficients and a function defining
a linear age model

\code{tddef} returns a function for the computation of TD values

\code{ghdef} returns a function for the computation of the general height

\code{pddef} returns a function for the computation of PD values

\code{lutdef} returns a look up table and a function for the
computation of the probability values for TD and PD

\code{gdef} returns a function to compute global indices

\code{lutgdef} returns a look up table and a function for the
computation of the probability values for global indices
}
\description{
Functions to generate and handle normative values. Check section
\code{Structure of normative values} below for details about how to generate
functioning normative values
}
\section{Structure of normative values}{

This is one of the most complex structures in visualFields. It is necessary
to be able to run statistical analyses of visual fields obtained from
perimetry and it requires data from healthy eyes for its generation. The
normative values are only as good as the data they are generated from. Two
common ways to generate full normative values from a dataset of healthy eyes,
are provided in the package, depending on the \code{method} selected. The first
one, \code{method="pointwise"}, generates normative values directly from
pointwise statistics. The second one, \code{method="smooth"}, uses a 2D
quadratic functions to smooth out those pointwise statistics. Variations
or improvements can be regenerated by copying the code in those functions and
editing it.
\itemize{
  \item\code{info} information regarding normative values. Info is not necessary
    to carry out statistics, but is useful for the generation of reports. The
    fields need not be the same as the ones listed here, although these are used
    in the reports in \code{\link{vfsfa}} for single field analysis and
    \code{\link{vfspa}} for series progression analysis.
    \itemize{
      \item\code{name} name of the normative values
      \item\code{perimetry} perimetry device for which normative values are intended
      \item\code{strategy} psychophysical strategy
      \item\code{size} stimulus size, e.g. Goldmann size III, size V
    }
  \item\code{agem} The normative values' age model. The default methods' generate
    age linear models with coefficients for each location in \code{locmap} in
    \code{coeff} and the function definining the model in \code{model}
  \item\code{sd} standard deviations of the sensitivities, \code{s}, total
  deviation (TD) values, \code{td}, and pattern deviation (PD) values, \code{pd}
  \item\code{luts} Lookup tables to obtain probability levels for TD and PD values.
    \itemize{
      \item\code{probs} probability levels
      \item\code{td}, \code{pd} lookup tables for TD and PD values at each location
        in \code{locmaps}
      \item\code{global} lookup table for the following global visual field indices
      \itemize{
        \item\code{ms} mean sensitivity (MS) calculated as the unweithed average
          over locations' values
        \item\code{ss} standard deviation of sensitivity calculated as the
          unweithed standard deviation over locations' values
        \item\code{md} mean deviation (MD) calculated as the weithed average
          over locations' values. Weights are the inverse of the standard
          deviation in \code{sd} for TD at each location.
        \item\code{sd} standard deviation of total deviation calculated as the
          weithed standard deviation over locations' values. Weights are the inverse of the standard
          deviation in \code{sd} for TD at each location.
        \item\code{pmd} pattern mean deviation calculated as the weithed average
          over locations' values. Weights are the inverse of the standard
          deviation in \code{sd} for PD at each location.
        \item\code{psd} pattern standard deviation calculated as the weithed
          standard deviation over locations' values. Weights are the inverse
          of the standard deviation in \code{sd} for PD at each location.
        \item\code{gh} general height. This is defined traditionally for the 24-2
        and the 30-2 as the approximatelly the 85th percentile of TD values
        \item\code{vfi} the oddly defined visual field index
      }
    }
  \item\code{tdfun} a function defining how to obtain the TD values. Typically, it
    is a function of age and sensitivity values and it is defined as sensitivity
    values minus the age-corrected mean normal obtained as defined in \code{agem}.
    Thus, TD values are negative is visual field sensitivity values are below
    mean normal and positive if they are above mean normal
  \item\code{ghfun} a function defining how to obtain the general height
  \item\code{pdfun} a function defining how to obtain the PD values. Tipically, they
    are obtaines as the TD values minus the general height
  \item\code{glfun} a function defining how to obtain different global indices
  \item\code{tdpfun}, \code{pdpfun}, \code{glpfun} mapping functions to get
    the probability levels corresponding to TD, PD and global indices values and
    based on the lookup tables defined in \code{luts}
}
}

\examples{
# generate normative values from SUNY-IU dataset of healthy eyes
# pointwise
sunyiu_24d2_pw <- nvgenerate(vfctrSunyiu24d2, method = "pointwise",
                             name      = "SUNY-IU pointwise NVs",
                             perimetry = "static automated perimetry",
                             strategy  = "SITA standard",
                             size      = "Size III")
# smooth
sunyiu_24d2 <- nvgenerate(vfctrSunyiu24d2, method = "smooth",
                          name      = "SUNY-IU smoothed NVs",
                          perimetry = "static automated perimetry",
                          strategy  = "SITA standard",
                          size      = "Size III")
}
