% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/undo_pr.R
\name{undo_pr}
\alias{undo_pr}
\title{Undo a product/ratio transformation}
\usage{
undo_pr(.data, .var, key = Sex, times = 2000)
}
\arguments{
\item{.data}{A vital object}

\item{.var}{A bare variable name of the measured variable to use.}

\item{key}{A bare variable name specifying the key variable to use. This key
variable must include the value \code{geometric_mean}.}

\item{times}{When the variable is a distribution, the product must be computed
by simulation. This argument specifies the number of simulations to use.}
}
\value{
A vital object
}
\description{
Make a new vital from products and ratios of a measured variable by a
key variable. The most common use case of this function is for computing mortality rates by
sex, from the sex ratios and geometric mean of the rates.
}
\details{
Note that when a measured variable takes value 0, the geometric mean
is set to 10^-6 to avoid infinite values in the ratio. Therefore, when the
transformation is undone, the results will not be identical to the original
in the case that the original data was 0.
}
\examples{
# Make products and ratios
orig_data <- aus_mortality |>
  dplyr::filter(Year > 2015, Sex != "total", Code == "NSW")
pr <- orig_data |>
  make_pr(Mortality)
# Compare original data with product/ratio version
orig_data
pr
# Undo products and ratios
pr |> undo_pr(Mortality)
}
\references{
Hyndman, R.J., Booth, H., & Yasmeen, F. (2013). Coherent
mortality forecasting: the product-ratio method with functional time series
models. \emph{Demography}, 50(1), 261-283.
}
