% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snv_segment.R
\name{snv_segment}
\alias{snv_segment}
\title{snv_segment}
\usage{
snv_segment(vardf)
}
\arguments{
\item{vardf}{A rearranged (arrange_data) and filtered (filtered_variants) vcf dataframe}
}
\value{
A bar plot showing the number of variants colored by their SNPEff annotation
}
\description{
Reads in a dataframe that has been arranged (arrange_data) and filtered (filter_variants) and outputs plots
}
\examples{
# Example 1: Simple data
df <- data.frame(sample = c("m1", "m1", "m1", "m1", "m1",
                            "m2", "m2", "m2", "m2", "m2"),
  CHROM = c("PB1", "PB1", "PB2", "PB2", "PB2",
	           "PB1", "PB1", "PB2", "PB2", "PB2"),
  annotation = c("downstrean_gene_variant", "synonymous_variant",
		              "synonymous_variant", "stop_gained", "missense_variant",
		          	  "downstrean_gene_variant", "downstrean_gene_variant",
				          "synonymous_variant", "stop_gained", "missense_variant")
)

df

snv_segment(df)

# Example 2: Sample data
snv_segment(example_filtered_SNV_df)

}
