% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markov.R
\name{identifyVocalisations}
\alias{identifyVocalisations}
\title{identifyVocalisations: replace appropriate vocalisation
    types}
\usage{
identifyVocalisations(vocvector, idswitchvoc = T)
}
\arguments{
\item{vocvector}{a character vector containing a sequence of
vocalisation events}

\item{idswitchvoc}{if TRUE distinguise between
SwitchingVocalisation and Vocalisation.}
}
\value{
A vector with all events replaced by the appropriate type
    identifier.
}
\description{
Identify switching vocalisations
}
\details{
SwitchingVocalisation is a vocalisation that signals a immediate
speaker transition; that is, a transition from speaker to
speaker (as opposed to speaker to Grp or speaker to Pause).

E.g (speakers A, B, C):
\preformatted{
AAAAAAAABBBBBBBCCCCCBBBBBPauseBBBBSwitchingPauseAAAAAGrp
       ^      ^    ^    ^        ^                  ^
       |      |    |    |        |                  |
       |      |    |    ----------- Non-SwitchingVocalisation
       |      |    |
       ---------------------> SwitchingVocalisation
}
}
\examples{
data(vocdia)
identifyVocalisations(atddia$speaker[1:60])
}
