% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R, R/model_chemo_wrapper.R
\docType{data}
\name{chemo_cea}
\alias{chemo_cea}
\alias{chemo_nb}
\alias{chemo_pars}
\alias{chemo_cea_501}
\alias{chemo_constants}
\alias{chemo_evsi_or}
\alias{chemo_model}
\alias{chemo_pars_fn}
\alias{chemo_model_nb}
\alias{chemo_model_cea}
\alias{chemo_model_lor_nb}
\alias{chemo_model_lor_cea}
\title{Chemotherapy cost-effectiveness model}
\format{
An object of class \code{list} of length 33.

An object of class \code{evsi} (inherits from \code{data.frame}) with 15030 rows and 3 columns.

Samples of 10000 from probabilistic analysis of this model are made available in the package, in the
following data objects:

\code{chemo_pars}: Sample from the distributions of the parameters, as a data frame with names as documented above.

\code{chemo_cea}: List with components \code{e} (sampled effects), \code{c} (sampled costs), and \code{k} (a set of five
equally-spaced willingess-to-pay values from 10000 to 50000 pounds).   The effects and costs are data frames
with two columns, one for each decision option.

\code{chemo_nb}: Data frame with two columns, giving the net monetary benefit for each decision option,
at a willingness-to-pay of 20000 pounds.

\code{chemo_cea_501}: List with components \code{e} (sampled effects), \code{c} (sampled costs), and \code{k} (a set of 501
willlingess-to-pay values from 10000 to 50000)  This is provided to facilitate illustrations of plots of
VoI measures against willingness-to-pay.

The following additional data objects are supplied:

\code{chemo_constants} includes various constants required by the code.

\code{chemo_evsi_or} is the result of an EVSI analysis to estimate the expected value of a two-arm trial, with a binary outcome, to estimate the log odds ratio of side effects.  This object is a data frame with three columns, giving the sample size per arm (\code{n}), willingness-to-pay (\code{k}) and the corresponding EVSI (\code{evsi}).
}
\usage{
chemo_cea

chemo_nb

chemo_pars

chemo_cea_501

chemo_constants

chemo_evsi_or

chemo_pars_fn(n)

chemo_model_nb(
  p_side_effects_t1,
  p_side_effects_t2,
  p_hospitalised_total,
  p_died,
  lambda_home,
  lambda_hosp,
  c_home_care,
  c_hospital,
  c_death,
  u_recovery,
  u_home_care,
  u_hospital,
  rate_longterm
)

chemo_model_cea(
  p_side_effects_t1,
  p_side_effects_t2,
  p_hospitalised_total,
  p_died,
  lambda_home,
  lambda_hosp,
  c_home_care,
  c_hospital,
  c_death,
  u_recovery,
  u_home_care,
  u_hospital,
  rate_longterm
)

chemo_model_lor_nb(
  p_side_effects_t1,
  logor_side_effects,
  p_hospitalised_total,
  p_died,
  lambda_home,
  lambda_hosp,
  c_home_care,
  c_hospital,
  c_death,
  u_recovery,
  u_home_care,
  u_hospital,
  rate_longterm
)

chemo_model_lor_cea(
  p_side_effects_t1,
  logor_side_effects,
  p_hospitalised_total,
  p_died,
  lambda_home,
  lambda_hosp,
  c_home_care,
  c_hospital,
  c_death,
  u_recovery,
  u_home_care,
  u_hospital,
  rate_longterm
)
}
\arguments{
\item{n}{Number of samples to generate from the uncertainty distribution of the parameters in \code{chemo_pars_fn}.}

\item{p_side_effects_t1}{Probability of side effects under treatment 1}

\item{p_side_effects_t2}{Probability of side effects under treatment 2}

\item{p_hospitalised_total}{Probability of hospitalisation in the year after receiving treatment}

\item{p_died}{Probability of death in the year after receiving treatment}

\item{lambda_home}{Recovery probability for someone treated at home}

\item{lambda_hosp}{Recovery probability for someone treated in hospital who does not die}

\item{c_home_care}{Cost of a yearly period under treatment at home}

\item{c_hospital}{Cost of hospital treatment}

\item{c_death}{Cost of death}

\item{u_recovery}{Utility of a period in the recovery state}

\item{u_home_care}{Utility of home care state}

\item{u_hospital}{Utility of hospital state}

\item{rate_longterm}{Long term mortality rate}

\item{logor_side_effects}{Log odds ratio of side effects for treatment 2 compared to 1}
}
\value{
Two alternative functions are provided to evaluate the decision model for given parameters.

\code{chemo_model_nb} returns a vector with elements giving the net monetary benefit for standard of care
and novel treatment, respectively, at a willingness-to-pay of 20,000 pounds per QALY.

\code{chemo_model_cea} returns a matrix with:
\itemize{
\item two rows, the first for expected costs and the second for expected effects (QALYs) over the fifty year time horizon, and
\item two columns, the first for the "standard of care" decision option, and the second for the novel
treatment.
}

\code{chemo_model_lor_nb} and \code{chemo_model_lor_cea} are the same model, but parameterised in terms of
the probability of side effects for the standard of care \code{p_side_effects_t1} and the log odds ratio
of side effects between treatment groups \code{logor_side_effects}, rather than in terms of
\code{p_side_effects_t1} and \code{p_side_effects_t2}

\code{chemo_pars_fn} generates a sample from the uncertainty distribution of the parameters in the chemotherapy model . This returns a data frame with parameters matching the arguments of
\code{\link{chemo_model_nb}}, and the following additional derived parameters:
\itemize{
\item \code{p_side_effects_t2}:
\item \code{p_hospitalised_total}: probability of hospitalisation over the 50 year time horizon
\item \code{p_died}: probability of death over the time horizon, given hospitalisation
\item \code{lambda_home}: conditional probability that a patient recovers given they are not hospitalised
\item \code{lambda_hosp}: conditional probability that a patient in hospital recovers given they do not die
}
}
\description{
An artificial health economic decision model with a typical Markov model structure, used for illustrating Value of Information methods.
Functions are provided to generate model parameters and evaluate the model, and samples from probabilistic analysis of the model are
provided as built-in datasets.
}
\details{
For more details, refer to Heath et al. (forthcoming book...)
}
\references{
Value of Information for Healthcare Decision Making
(CRC Press, eds. Heath, Kunst and Jackson: forthcoming)
}
\keyword{datasets}
