\name{evoigt}
\alias{evoigt}
\title{
Estimation of Voigt distribution parameters
}
\description{
The function provides both point and interval estimates for the Voigt distribution parameters in a Bayesian way (see Details).
}
\usage{
evoigt(data, hyper = NULL, init = NULL, S = 10000, burn = S/2,
thin = 10, fix.arg = NULL, chain = FALSE, ...)
}
\arguments{
  \item{data}{
  A numeric vector of length at least one containing only finite values.
}
  \item{hyper}{
A numeric vector of length six giving the hyperparameters for \code{mu}, \code{sigma} and \code{gamma} priors (in this order).  If \code{NULL} all hyperparameters are set to 0.1.
}
  \item{init}{
The starting values for the chain parameters. If NULL (default) all chains start at 1. If \emph{scalar} it is used as the common starting value. If \emph{character} it can be set either to "\code{rand}" for random starting values or to "\code{datadriven}" for quantile based estimation of starting values. 
}
  \item{S}{
The number of iterations in the Gibbs sampler. Default to \eqn{20000}. 
}
  \item{burn}{
The number of initial chain values to be discarded (\emph{burn-in} period). Default to \eqn{S/2}.
}
  \item{thin}{
 This parameter allows the user to specify if and how the chain should be thinned after burn-in. By default thin = 5 is used, which corresponds to keeping 1/5 of the chain values.
}
  \item{fix.arg}{
	An optional vector of length 3 giving the values of fixed parameters of the Voigt distribution, in this order: \eqn{\mu,\sigma, \gamma} with NA corresponding to an unknown parameter. By default all parameters are estimated. Parameters with fixed value are thus NOT estimated by the Gibbs sampler procedure.
}
  \item{chain}{
logical; if TRUE the output contains also the (thinned) chains values after burn-in. The first value of the chains is set according to the \code{init} argument.
}
  \item{\dots}{
Additional arguments to be passed to functions of the package \code{coda}. A \code{prob} argument can be used to specify the required probability of the credibility intervals via the \code{\link[coda]{HPDinterval}} function (default is \code{0.95}; see the examples). Note that if \code{S} is too small the final probability can be different from the required one .
}
}
\details{
The function runs a Gibbs sampler for estimating parameters using the following prior distributions: 
\eqn{\mu\sim N(\mu_0, \nu_0^2)}, \eqn{\sigma\sim \Gamma(a, b)} and \eqn{\gamma\sim \Gamma(c, d)}.
}
\value{
\code{evoigt} returns a list with the following components:
    \item{posterior mean}{the vector of posterior means}
    \item{posterior median}{the vector of posterior medians}
    \item{HPD interval}{the highest probability density intervals for the parameters}
    \item{chain}{the thinned chain values after burn-in (only if argument \code{chain} is TRUE.)}
}
\references{
Cannas, M. and Piras, N. (2025) Estimation of Voigt Distribution Parameters: A Bayesian Approach. \emph{(conference paper)}
\url{https://link.springer.com/chapter/10.1007/978-3-031-96303-2_53}

Cannas, M. and Piras, N. Mixture representation and parameter estimation for the Voigt profile (\emph{submitted})
}
\author{
\packageAuthor{voigt}
}

\seealso{
See \code{\link[coda]{HPDinterval}} for details on how the highest posterior density interval is built.
}
\examples{
x = rvoigt(500, mu=0, sigma=1,gamma=1)
# point estimates and (default) 95\% credibility intervals
evoigt(data=x)
# point estimates and 90\% credibility intervals
evoigt(data=x, prob = 0.9)
# chain values
res = evoigt(data=x, prob = 0.9, chain=TRUE)
mu.chain = res$mu.chain
plot(0: (length(mu.chain)-1), type = "l", mu.chain, xlab="",ylab=c(expression(mu)) )
points(0,mu.chain[1],pch=1,col="red")
# if a parameter is known its value can be fixed using "fix.arg"
# e.g. set sigma =1:
res = evoigt(data=x, fix.arg=c(NA, 1, NA))
res["posterior mean"]
res["posterior median"]
res["HPD interval"]
}

