% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_counts_one}
\alias{plot_counts_one}
\title{Plot the frequency of values in one column}
\usage{
plot_counts_one(
  data,
  col,
  category = NULL,
  ci = FALSE,
  limits = NULL,
  numbers = NULL,
  title = TRUE,
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble.}

\item{col}{The column holding values to count.}

\item{category}{The value FALSE will force to plot all categories.
A character value will focus a selected category.
When NULL, in case of boolean values, only the TRUE category is plotted.}

\item{ci}{Whether to plot error bars for 95\% confidence intervals.}

\item{limits}{The scale limits, autoscaled by default.
Set to \code{c(0,100)} to make a 100\% plot.
If the data is binary or focused on a single category, by default a 100\% plot is created.}

\item{numbers}{The values to print on the bars: "n" (frequency), "p" (percentage) or both.}

\item{title}{If TRUE (default) shows a plot title derived from the column labels.
Disable the title with FALSE or provide a custom title as character value.}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{plot_counts}.}
}
\value{
A ggplot object.
}
\description{
Plot the frequency of values in one column
}
\examples{
library(volker)
data <- volker::chatgpt

plot_counts_one(data, sd_gender)

}
\keyword{internal}
