% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddText.R
\name{vosonSML::AddText.actor.youtube}
\alias{vosonSML::AddText.actor.youtube}
\alias{AddText.actor.youtube}
\title{Add columns containing text data to youtube actor network dataframes}
\usage{
\method{AddText}{actor.youtube}(net, data, repliesFromText = FALSE, atRepliesOnly = TRUE, ...)
}
\arguments{
\item{net}{A named list of dataframes \code{nodes} and \code{edges} generated by \code{Create}.}

\item{data}{A dataframe generated by \code{Collect}.}

\item{repliesFromText}{Logical. If comment text for an edge begins with \code{screen_name} change the
edge to be directed to \code{screen_name} - if different from the top level comment author that the reply
comment was posted to. Default is \code{FALSE}.}

\item{atRepliesOnly}{Logical. Comment \code{screen_names} must begin with an '@' symbol to be redirected.
Default is \code{TRUE}.}

\item{...}{Additional parameters passed to function. Not used in this method.}
}
\value{
Network as a named list of two dataframes containing \code{$nodes} and \code{$edges}
including columns containing text data.
}
\description{
Text comments are added to the network as edge attributes. References to actors
are detected at the beginning of comments and edges redirected to that actor instead if they
differ from the top-level comment author.
}
\examples{
\dontrun{
# add text to an actor network ignoring references to actors at the beginning of
# comment text
activityNetwork <- collectData \%>\% Create("activity") \%>\% 
                                   AddText(collectData, repliesFromText = FALSE)

# network
# activityNetwork$nodes
# activityNetwork$edges
}

}
