% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rating_get_sig_list.R
\name{rating_get_sig_list}
\alias{rating_get_sig_list}
\title{Get SIG (Special Interest Group) list by category and state}
\usage{
rating_get_sig_list(category_ids, state_ids = NA, all = TRUE, verbose = TRUE)
}
\arguments{
\item{category_ids}{Vector of category ids.}

\item{state_ids}{Vector of state abbreviations. Default \code{NA} for national.}

\item{all}{Boolean: should all possible combinations of the variables be searched for, or just the exact combination of them in the order they are supplied?}

\item{verbose}{Should cases when no data is available be messaged?}
}
\value{
A dataframe with the columns \code{sig_id, name, category_id, state_id}.
}
\description{
Get SIG (Special Interest Group) list by category and state
}
\examples{

\dontrun{
rating_get_categories() \%>\%
  dplyr::pull(category_id) \%>\%
  sample(3) \%>\%
  rating_get_sig_list()
}
}
