% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts2matrix.R
\name{ts2matrix}
\alias{ts2matrix}
\title{Timeseries to Matrix}
\usage{
ts2matrix(image, mask)
}
\arguments{
\item{image}{Input image of type 'nifti'}

\item{mask}{Input mask of type 'nifti'. Must be a binary mask}
}
\description{
This function is able to mask a 4-Dimensional image and create a matrix from it. 
Each column represents the same voxel in the xyz array while the rows represent the t-dimension.
}
\examples{


image <- oro.nifti::nifti(img = array(1:64, dim =c(4,4,4,5)))
mask <- oro.nifti::nifti(img = array(0:1, dim = c(4,4,4)))
matrix <- ts2matrix(image, mask)
}
\keyword{internal}
