% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpc.R
\name{vpc}
\alias{vpc}
\title{VPC function}
\usage{
vpc(sim = NULL, obs = NULL, psn_folder = NULL, bins = "jenks",
  n_bins = "auto", bin_mid = "mean", obs_cols = NULL, sim_cols = NULL,
  software = "auto", show = NULL, stratify = NULL, pred_corr = FALSE,
  pred_corr_lower_bnd = 0, pi = c(0.05, 0.95), ci = c(0.05, 0.95),
  uloq = NULL, lloq = NULL, log_y = FALSE, log_y_min = 0.001,
  xlab = NULL, ylab = NULL, title = NULL, smooth = TRUE,
  vpc_theme = NULL, facet = "wrap", labeller = NULL, vpcdb = FALSE,
  verbose = FALSE)
}
\arguments{
\item{sim}{a data.frame with observed data, containing the independent and dependent variable, a column indicating the individual, and possibly covariates. E.g. load in from NONMEM using \link{read_table_nm}}

\item{obs}{a data.frame with observed data, containing the independent and dependent variable, a column indicating the individual, and possibly covariates. E.g. load in from NONMEM using \link{read_table_nm}}

\item{psn_folder}{instead of specifying "sim" and "obs", specify a PsN-generated VPC-folder}

\item{bins}{either "density", "time", or "data", "none", or one of the approaches available in classInterval() such as "jenks" (default) or "pretty", or a numeric vector specifying the bin separators.}

\item{n_bins}{when using the "auto" binning method, what number of bins to aim for}

\item{bin_mid}{either "mean" for the mean of all timepoints (default) or "middle" to use the average of the bin boundaries.}

\item{obs_cols}{observation dataset column names (list elements: "dv", "idv", "id", "pred")}

\item{sim_cols}{simulation dataset column names (list elements: "dv", "idv", "id", "pred")}

\item{software}{name of software platform using (e.g. nonmem, phoenix)}

\item{show}{what to show in VPC (obs_dv, obs_ci, pi, pi_as_area, pi_ci, obs_median, sim_median, sim_median_ci)}

\item{stratify}{character vector of stratification variables. Only 1 or 2 stratification variables can be supplied.}

\item{pred_corr}{perform prediction-correction?}

\item{pred_corr_lower_bnd}{lower bound for the prediction-correction}

\item{pi}{simulated prediction interval to plot. Default is c(0.05, 0.95),}

\item{ci}{confidence interval to plot. Default is (0.05, 0.95)}

\item{uloq}{Number or NULL indicating upper limit of quantification. Default is NULL.}

\item{lloq}{Number or NULL indicating lower limit of quantification. Default is NULL.}

\item{log_y}{Boolean indicting whether y-axis should be shown as logarithmic. Default is FALSE.}

\item{log_y_min}{minimal value when using log_y argument. Default is 1e-3.}

\item{xlab}{ylab as numeric vector of size 2}

\item{ylab}{ylab as numeric vector of size 2}

\item{title}{title}

\item{smooth}{"smooth" the VPC (connect bin midpoints) or show bins as rectangular boxes. Default is TRUE.}

\item{vpc_theme}{theme to be used in VPC. Expects list of class vpc_theme created with function vpc_theme()}

\item{facet}{either "wrap", "columns", or "rows"}

\item{labeller}{ggplot2 labeller function to be passed to underlying ggplot object}

\item{vpcdb}{Boolean whether to return the underlying vpcdb rather than the plot}

\item{verbose}{show debugging information (TRUE or FALSE)}
}
\value{
a list containing calculated VPC information (when vpcdb=TRUE), or a ggplot2 object (default)
}
\description{
Creates a VPC plot from observed and simulation data
}
\examples{

## See vpc.ronkeizer.com for more documentation and examples
library(vpc)

# Basic commands:
vpc(sim = simple_data$sim, obs = simple_data$obs)
vpc(sim = simple_data$sim, obs = simple_data$obs, lloq = 20)

}
\seealso{
\link{sim_data}, \link{vpc_cens}, \link{vpc_tte}, \link{vpc_cat}
}
