% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vtreat.R
\name{track_values}
\alias{track_values}
\title{Track unique character values for variables.}
\usage{
track_values(dframe, varlist)
}
\arguments{
\item{dframe}{Data frame to learn treatments from (training data), must have at least 1 row.}

\item{varlist}{Names of columns to treat (effective variables).}
}
\value{
named list of values seen.
}
\description{
Builds lists of observed unique character values of varlist variables from the data frame.
}
\examples{

set.seed(23525)
zip <- c(NA, paste('z', 1:100, sep = "_"))
N <- 500
d <- data.frame(zip = sample(zip, N, replace=TRUE),
                zip2 = sample(zip, N, replace=TRUE),
                y = runif(N))
dSample <- d[1:300, , drop = FALSE]
tplan <- designTreatmentsN(dSample, 
                           c("zip", "zip2"), "y", 
                           verbose = FALSE)
trackedValues <- track_values(dSample, c("zip", "zip2"))
# don't normally want to catch warnings,
# doing it here as this is an example 
# and must not have unhandled warnings.
tryCatch(
  prepare(tplan, d, trackedValues = trackedValues),
  warning = function(w) { cat(paste(w, collapse = "\\n")) })

}
\seealso{
\code{\link{prepare.treatmentplan}}, \code{\link{novel_value_summary}}
}
