% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_bouts_and_gps_epochs_into_walkbouts.R
\name{generate_bout_radius}
\alias{generate_bout_radius}
\title{Generate Bounding Circle Radius for Walking Bouts}
\usage{
generate_bout_radius(walk_bouts, dwellbout_radii_quantile)
}
\arguments{
\item{walk_bouts}{A data frame containing GPS locations for each walking bout, with columns "longitude", "latitude", and "bout" (a unique identifier for each bout)}

\item{dwellbout_radii_quantile}{A quantile (between 0 and 1) used to filter outlying GPS data points before generating the bounding circle. GPS points with a distance from the center greater than the radius of the circle that contains (1 - dwellbout_radii_quantile) of the GPS points are considered outliers and are excluded.}
}
\value{
A data frame containing the bout identifier and the radius of the bounding circle for each walking bout.
}
\description{
This function generates a bounding circle radius for each walking bout identified in the input data. The bounding circle is defined as the smallest circle that fully contains all GPS locations observed during a walking bout.
}
