% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/imp.syrinx.R
\name{imp.syrinx}
\alias{imp.syrinx}
\title{Import Syrinx selections}
\usage{
imp.syrinx(path = NULL, all.data = FALSE, recursive = FALSE)
}
\arguments{
\item{path}{A character string indicating the path of the directory in which to look for the text files.
If not provided (default) the function searches into the current working directory. Default is \code{NULL}).}

\item{all.data}{Logical. If \code{TRUE}) all columns in text files are returned. Default is \code{FALSE}). Note
that all files should contain exactly the same columns in the same order.}

\item{recursive}{Logical. If \code{TRUE}) the listing recurse into sub-directories.}
}
\value{
A single data frame with the information from the selection files. If all.data argument is set to \code{FALSE}) the data
frame contains the following columns: selec, start, end, and selec.file. If sound.file.col is provided the data frame
will also contain a sound.file column. In addition, all rows with duplicated data are removed. This is useful when
both spectrogram and waveform views are included in the Syrinx selection files. If all.data is set to \code{TRUE}) then all
columns in selection files are returned.
}
\description{
\code{imp.syrinx} Imports Syrinx selection data from many files simultaneously.
All files must be have the same columns.
}
\examples{
\dontrun{
# First set temporary folder
setwd(tempdir())

#load data
data(selection.files)

write.table(selection.files[[3]],file = "harpyeagle.wav.txt",row.names = F,
 col.names = F, sep= "\\t")

write.table(selection.files[[4]],file = "Phae.long4.wav.txt",row.names = F,
col.names = F, sep= "\\t")

syr.dat<-imp.syrinx(all.data = FALSE)

View(syr.dat)

#getting all the data
syr.dat<-imp.syrinx(all.data = TRUE)

View(syr.dat)
}
}
\author{
Marcelo Araya-Salas (\url{http://marceloarayasalas.weebly.com/})
}

