% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAffectedRCW.R
\name{getAffectedRCW}
\alias{getAffectedRCW}
\title{Link bills to Revised Code of Washington (RCW)}
\usage{
getAffectedRCW(biennium, billId, paired = TRUE, type = c("df", "list", "xml"))
}
\arguments{
\item{biennium}{Character vector representing the biennium(s) to be
searched. Each argument should take the form "XXXX-YY"}

\item{billId}{Character vector containing the bill(s) to be retrieved.
Each argument should take the form "XX YYYY", where XX
is the prefix (HB, SB, etc.) and YYYY is the bill number.}

\item{paired}{If TRUE, will assume that equal length vectors represent
paired data. Set to FALSE to generate an NxN grid of input
arguments. Applies to equal length vector inputs only.}

\item{type}{One of "df", "list", or "xml". Specifies the format for
the output.}
}
\value{
\code{getAffectedRCW} returns an object of type equal to the
\code{type} argument (defaults to dataframe)
}
\description{
Get a listing of all RCW citations affected by a given bill
}
\section{Note}{
 for more information on RCW codes, see
\url{https://apps.leg.wa.gov/rcw/}
}

\examples{
## usage for a single bill case, XML form
getAffectedRCW("2005-06", "HB 1427", type = "xml")

## generates a dataframe of affected codes from all bills in 2007
\dontrun{
bills <- getLegislationByYear("2007")
codesAffected <- getAffectedRCW("2007-08", bills$BillId)}

}
