\name{cleanUp}
\alias{cleanUp}
\title{Cleans up hydrologic time series data}
\usage{
  cleanUp(dataset, task = "view", replace = 0.1)
}
\arguments{
  \item{dataset}{is a data frame in format of the data
  frame returned by \link{importDVs}.}

  \item{task}{is either "view" or "fix."  View will return
  a list containing rows with negative values and rows with
  missing values.  Fix will replace negative values with NA
  and replace zeroes with the value specified by the
  replace argument.}

  \item{replace}{is the value used to replace 0 values.
  The default is 0.1.  For streamflow in small streams, one
  might want to use 0.01. For daily data other than
  streamflow, such as turbidity, users may not want to
  replace 0 values with a nonzero value.  In those cases,
  replace can be set to 0.}
}
\value{
  A list showing days with negative values and days with
  values of 0 when task is "view."  When task is "fix" the
  fixed dataset is returned. When a negative value is
  replaced with NA, an "N" is added to the qualcode field
  to indicate that there had been a negative number. When a
  zero value is replaced, an "R" is added to the qualcode
  field to indicate that a zero value was replaced.
}
\description{
  Function to identify and fix common problems with
  hydrologic data
}
\note{
  If calculating anomalies (see \link{compAnom}), the user
  may need to replace isolated missing values with with a
  value; however, if there are larger periods with missing
  values, streamflow anomalies may not be an appropriate
  use of the data.  The substitution of some missing data
  with values may be done using the function
  \link{fillMiss} that is part of this package.  However,
  care needs to be taken when filling in missing data.
}
\examples{
data(exampleWaterData)
head(badDataSet)
cleanUp(badDataSet, task="view")
q05054000Fix <- cleanUp(badDataSet, task="fix")
# replace 0s with NA, then one could use the fillMiss function
# to estimate values
q05054000Fix2 <- cleanUp(badDataSet, task="fix", replace=NA)
summary(badDataSet)
summary(q05054000Fix)
summary(q05054000Fix2)
}
\seealso{
  \link{fillMiss}
}
\keyword{manip}
\keyword{NA}
\keyword{ts}
\keyword{utilities}

