% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fourier_factor.R
\name{fourier_factor}
\alias{fourier_factor}
\title{Fourier factor of a wavelet}
\usage{
fourier_factor(wname = c("MORLET", "DOG", "PAUL", "HAAR", "HAAR2"),
                      wparam = NULL)
}
\arguments{
\item{wname}{A string, equal to "MORLET", "DOG", "PAUL", "HAAR" or "HAAR2" that
determines the wavelet function.}

\item{wparam}{The corresponding nondimensional parameter for the wavelet function
(Morlet, DoG or Paul).}
}
\value{
The numeric value of the Fourier factor.
}
\description{
This function computes the Fourier factor of a wavelet, according to
Torrence and Compo (1998).
}
\section{References}{


C. Torrence, G. P. Compo. A practical guide to wavelet analysis. B. Am. Meteorol. Soc.
79 (1998), 61–78.
}

\examples{
ff <- fourier_factor(wname = "DOG", wparam = 6)

}
