### * <HEADER>
###
attach(NULL, name = "CheckExEnv")
assign(".CheckExEnv", as.environment(2), pos = length(search())) # base
## add some hooks to label plot pages for base and grid graphics
setHook("plot.new", ".newplot.hook")
setHook("persp", ".newplot.hook")
setHook("grid.newpage", ".gridplot.hook")

assign("cleanEx",
       function(env = .GlobalEnv) {
	   rm(list = ls(envir = env, all.names = TRUE), envir = env)
           RNGkind("default", "default")
	   set.seed(1)
   	   options(warn = 1)
	   delayedAssign("T", stop("T used instead of TRUE"),
		  assign.env = .CheckExEnv)
	   delayedAssign("F", stop("F used instead of FALSE"),
		  assign.env = .CheckExEnv)
	   sch <- search()
	   newitems <- sch[! sch %in% .oldSearch]
	   for(item in rev(newitems))
               eval(substitute(detach(item), list(item=item)))
	   missitems <- .oldSearch[! .oldSearch %in% sch]
	   if(length(missitems))
	       warning("items ", paste(missitems, collapse=", "),
		       " have been removed from the search path")
       },
       env = .CheckExEnv)
assign("..nameEx", "__{must remake R-ex/*.R}__", env = .CheckExEnv) # for now
assign("ptime", proc.time(), env = .CheckExEnv)
grDevices::postscript("waved-Examples.ps")
assign("par.postscript", graphics::par(no.readonly = TRUE), env = .CheckExEnv)
options(contrasts = c(unordered = "contr.treatment", ordered = "contr.poly"))
options(warn = 1)    
library('waved')

assign(".oldSearch", search(), env = .CheckExEnv)
assign(".oldNS", loadedNamespaces(), env = .CheckExEnv)
cleanEx(); ..nameEx <- "BlurSignal"

### * BlurSignal

flush(stderr()); flush(stdout())

### Name: BlurSignal
### Title: Blurr Signal
### Aliases: BlurSignal
### Keywords: internal

### ** Examples
 
x=1:10
y=1:10 
BlurSignal(x,y)




cleanEx(); ..nameEx <- "FWT.TI"

### * FWT.TI

flush(stderr()); flush(stdout())

### Name: FWT_TI
### Title: Forward Wavelet Transform (translation invariant).
### Aliases: FWT_TI
### Keywords: internal

### ** Examples

 psyJ_fft=wavelet_YM(4,10,3);
 f_fft=fft(sin(2*pi*seq(0,1,le=1024)))
 FWT_TI(f_fft,psyJ_fft)
 


cleanEx(); ..nameEx <- "FWaveD"

### * FWaveD

flush(stderr()); flush(stdout())

### Name: FWaveD
### Title: FWaveD
### Aliases: FWaveD
### Keywords: nonparametric

### ** Examples

library(waved)
data=waved.example(TRUE,FALSE)
lidar.w=FWaveD(data$lidar.blur,data$g)



cleanEx(); ..nameEx <- "HardThresh"

### * HardThresh

flush(stderr()); flush(stdout())

### Name: HardThresh
### Title: Hard Threshold
### Aliases: HardThresh
### Keywords: internal

### ** Examples

HardThresh(1:5,2)
  


cleanEx(); ..nameEx <- "IFWT.TI"

### * IFWT.TI

flush(stderr()); flush(stdout())

### Name: IFWT_TI
### Title: Inverse Forward Wavelet Transform (translation invariant).
### Aliases: IFWT_TI
### Keywords: internal

### ** Examples

psyJ_fft=wavelet_YM(4,10,3);
f_fft=fft(sin(2*pi*seq(0,1,le=1024)));
IFWT_TI(f_fft, psyJ_fft, 4, 0, 1024)



cleanEx(); ..nameEx <- "IWaveD"

### * IWaveD

flush(stderr()); flush(stdout())

### Name: IWaveD
### Title: Computes the Inverse WaveD transform
### Aliases: IWaveD
### Keywords: internal

### ** Examples

library(waved)
data=waved.example(TRUE,FALSE)
lidar.w=FWaveD(data$lidar.blur,data$g)  # lidar.blur is lidar*g 
IWaveD(lidar.w)               # same as lidar



cleanEx(); ..nameEx <- "MeyerWindow"

### * MeyerWindow

flush(stderr()); flush(stdout())

### Name: MeyerWindow
### Title: Meyer wavelet window
### Aliases: MeyerWindow
### Keywords: internal

### ** Examples

  plot(seq(0,1,le=1000),MeyerWindow(seq(0,1,le=1000),3),type='l')



cleanEx(); ..nameEx <- "MultiThresh1"

### * MultiThresh1

flush(stderr()); flush(stdout())

### Name: MultiThresh1
### Title: Maxiset threshold
### Aliases: MultiThresh1
### Keywords: internal

### ** Examples


MultiThresh1(.1, sin(2*pi*seq(0,1,le=1024)), 3, sqrt(2))



cleanEx(); ..nameEx <- "PhaseC"

### * PhaseC

flush(stderr()); flush(stdout())

### Name: PhaseC
### Title: Phase matrix
### Aliases: PhaseC
### Keywords: internal

### ** Examples

PhaseC(3,4)



cleanEx(); ..nameEx <- "SoftThresh"

### * SoftThresh

flush(stderr()); flush(stdout())

### Name: SoftThresh
### Title: Soft Threshold
### Aliases: SoftThresh
### Keywords: internal

### ** Examples

SoftThresh(1:5,2)
  


cleanEx(); ..nameEx <- "WaveD"

### * WaveD

flush(stderr()); flush(stdout())

### Name: WaveD
### Title: WaveD
### Aliases: WaveD
### Keywords: nonparametric

### ** Examples

library(waved)
data=waved.example(TRUE,FALSE)
doppler.wvd=WaveD(data$doppler.noisy,data$g)
summary(doppler.wvd)



cleanEx(); ..nameEx <- "WaveDjC"

### * WaveDjC

flush(stderr()); flush(stdout())

### Name: WaveDjC
### Title: WaveD projection, coarse level.
### Aliases: WaveDjC
### Keywords: internal

### ** Examples


waveJ0_fft=scaling_YM(3,10,3);
WaveDjC(fft(sin(2*pi*seq(0,1,le=1024))),waveJ0_fft,3)



cleanEx(); ..nameEx <- "WaveDjD"

### * WaveDjD

flush(stderr()); flush(stdout())

### Name: WaveDjD
### Title: WaveD projection, details.
### Aliases: WaveDjD
### Keywords: internal

### ** Examples


waveJ0_fft=wavelet_YM(5,10,3);
WaveDjD(fft(sin(2*pi*seq(0,1,le=1024))),waveJ0_fft,3)



cleanEx(); ..nameEx <- "WaveDjF"

### * WaveDjF

flush(stderr()); flush(stdout())

### Name: WaveDjF
### Title: WaveD projection, fine resolution level.
### Aliases: WaveDjF
### Keywords: internal

### ** Examples


waveJ0_fft=fine_YM(9,10,3);
WaveDjF(fft(sin(2*pi*seq(0,1,le=1024))),waveJ0_fft,3)



cleanEx(); ..nameEx <- "dyad"

### * dyad

flush(stderr()); flush(stdout())

### Name: dyad
### Title: Dyadic band
### Aliases: dyad
### Keywords: internal

### ** Examples

library(waved)
data=waved.example(TRUE,FALSE)
lidar.w=FWaveD(data$lidar.blur,data$g)
lidar.w[dyad(7)]



cleanEx(); ..nameEx <- "dyadjk"

### * dyadjk

flush(stderr()); flush(stdout())

### Name: dyadjk
### Title: Lexicographic ordering (dyadic)
### Aliases: dyadjk
### Keywords: internal

### ** Examples

print(dyadjk(5,4))
  


cleanEx(); ..nameEx <- "fftshift"

### * fftshift

flush(stderr()); flush(stdout())

### Name: fftshift
### Title: Shift Fourier frequencies
### Aliases: fftshift
### Keywords: internal

### ** Examples
 print(fftshift(1:5))


cleanEx(); ..nameEx <- "find.j1"

### * find.j1

flush(stderr()); flush(stdout())

### Name: find.j1
### Title: Fine resolution level for WaveD fit
### Aliases: find.j1
### Keywords: internal

### ** Examples

library(waved)
data=waved.example(TRUE,FALSE)
find.j1(data$g,data$sigma)




cleanEx(); ..nameEx <- "findONE"

### * findONE

flush(stderr()); flush(stdout())

### Name: findONE
### Title: Find positive entries
### Aliases: findONE
### Keywords: internal

### ** Examples
findONE(-5:5)



cleanEx(); ..nameEx <- "findZERO"

### * findZERO

flush(stderr()); flush(stdout())

### Name: findZERO
### Title: Find negative entries
### Aliases: findZERO
### Keywords: internal

### ** Examples

findZERO(-5:5)



cleanEx(); ..nameEx <- "fine.YM"

### * fine.YM

flush(stderr()); flush(stdout())

### Name: fine_YM
### Title: ~~function to do ... ~~
### Aliases: fine_YM
### Keywords: internal

### ** Examples

fine_YM(9,10,3)



cleanEx(); ..nameEx <- "make.doppler"

### * make.doppler

flush(stderr()); flush(stdout())

### Name: make.doppler
### Title: Make Doppler signal
### Aliases: make.doppler
### Keywords: internal

### ** Examples

plot(seq(0,1,le=1000),make.doppler(1000),type='l')



cleanEx(); ..nameEx <- "make.lidar"

### * make.lidar

flush(stderr()); flush(stdout())

### Name: make.lidar
### Title: Make LIDAR signal
### Aliases: make.lidar
### Keywords: internal

### ** Examples

plot(seq(0,1,le=1000),make.lidar(1000),type='l')



cleanEx(); ..nameEx <- "maxithresh"

### * maxithresh

flush(stderr()); flush(stdout())

### Name: maxithresh
### Title: Returns maxiset threshold
### Aliases: maxithresh
### Keywords: internal

### ** Examples

library(waved)
data=waved.example(TRUE,FALSE)
maxithresh(data$lidar.noisy,data$g,L=3,F=7)



cleanEx(); ..nameEx <- "multires"

### * multires

flush(stderr()); flush(stdout())

### Name: multires
### Title: Create Multi-resolution Plot
### Aliases: multires
### Keywords: internal

### ** Examples

library(waved)
data=waved.example(TRUE,FALSE)
lidar.w=FWaveD(data$lidar.blur,data$g,F=7)
multires(lidar.w,lo=3,hi=7)



cleanEx(); ..nameEx <- "phyHAT"

### * phyHAT

flush(stderr()); flush(stdout())

### Name: phyHAT
### Title: Meyer scaling function (Fourier domain).
### Aliases: phyHAT
### Keywords: internal

### ** Examples

plot(seq(-2,2,le=1000),abs(phyHAT(seq(-2,2,le=1000),3)),type='l')




cleanEx(); ..nameEx <- "plot.wvd"

### * plot.wvd

flush(stderr()); flush(stdout())

### Name: plot.wvd
### Title: Plot wvd objects
### Aliases: plot.wvd
### Keywords: internal

### ** Examples

library(waved)
data=waved.example(TRUE,FALSE)
doppler.wvd=WaveD(data$doppler.noisy,data$g)
plot(doppler.wvd)




cleanEx(); ..nameEx <- "plotspec"

### * plotspec

flush(stderr()); flush(stdout())

### Name: plotspec
### Title: Plot spectrum
### Aliases: plotspec
### Keywords: internal

### ** Examples
plotspec(sin(2*pi*seq(0,1,le=1024)),0.01) 


cleanEx(); ..nameEx <- "projFj"

### * projFj

flush(stderr()); flush(stdout())

### Name: projFj
### Title: Projection onto $F_j$
### Aliases: projFj
### Keywords: internal

### ** Examples

 plot(projFj(rnorm(1024),1024,3))



cleanEx(); ..nameEx <- "projVj"

### * projVj

flush(stderr()); flush(stdout())

### Name: projVj
### Title: Projection onto $V_j$
### Aliases: projVj
### Keywords: internal

### ** Examples

 plot(projVj(rnorm(512),1024,3))



cleanEx(); ..nameEx <- "projWj"

### * projWj

flush(stderr()); flush(stdout())

### Name: projWj
### Title: Projection onto $W_j$
### Aliases: projWj
### Keywords: internal

### ** Examples

 plot(projWj(rnorm(512),1024,3))



cleanEx(); ..nameEx <- "psyHAT"

### * psyHAT

flush(stderr()); flush(stdout())

### Name: psyHAT
### Title: Meyer wavelet function (Fourier domain).
### Aliases: psyHAT
### Keywords: internal

### ** Examples

plot(seq(-2,2,le=1000),abs(psyHAT(seq(-2,2,le=1000),3)),type='l')




cleanEx(); ..nameEx <- "rot90"

### * rot90

flush(stderr()); flush(stdout())

### Name: rot90
### Title: Rotate matrix 90 degrees
### Aliases: rot90
### Keywords: internal

### ** Examples
 rot90(1:5)


cleanEx(); ..nameEx <- "scale"

### * scale

flush(stderr()); flush(stdout())

### Name: scale
### Title: Estimates standard deviation of noise
### Aliases: scale
### Keywords: internal

### ** Examples

library(waved)
data=waved.example(TRUE,FALSE)
scale(data$lidar.noisy)



cleanEx(); ..nameEx <- "scaling.YM"

### * scaling.YM

flush(stderr()); flush(stdout())

### Name: scaling_YM
### Title: Meyer scaling function, Fourier domain.
### Aliases: scaling_YM
### Keywords: internal

### ** Examples

scaling_YM(9,10,3)



cleanEx(); ..nameEx <- "speczoom"

### * speczoom

flush(stderr()); flush(stdout())

### Name: speczoom
### Title: Plot spectrum
### Aliases: speczoom
### Keywords: internal

### ** Examples
speczoom(sin(2*pi*seq(0,1,le=1024)),200) 


cleanEx(); ..nameEx <- "stoptime"

### * stoptime

flush(stderr()); flush(stdout())

### Name: stoptime
### Title: Optimal stoping time
### Aliases: stoptime
### Keywords: internal

### ** Examples

stoptime(log(abs(sin(2*pi*seq(0,1,le=1024)))),1)



cleanEx(); ..nameEx <- "summary.wvd"

### * summary.wvd

flush(stderr()); flush(stdout())

### Name: summary.wvd
### Title: Summary of wvd objects
### Aliases: summary.wvd
### Keywords: internal

### ** Examples

library(waved)
data=waved.example(TRUE,FALSE)
doppler.wvd=WaveD(data$doppler.noisy,data$g)
summary(doppler.wvd)



cleanEx(); ..nameEx <- "threshsum"

### * threshsum

flush(stderr()); flush(stdout())

### Name: threshsum
### Title: Show threshold effects
### Aliases: threshsum
### Keywords: internal

### ** Examples

library(waved)
data=waved.example(TRUE,FALSE)
doppler.wvd=WaveD(data$doppler.noisy,data$g)
threshsum(doppler.wvd$w,3,8)




cleanEx(); ..nameEx <- "waved.example"

### * waved.example

flush(stderr()); flush(stdout())

### Name: waved.example
### Title: WaveD examples
### Aliases: waved.example
### Keywords: nonparametric

### ** Examples
 
data=waved.example(TRUE,FALSE)



cleanEx(); ..nameEx <- "wavelet.YM"

### * wavelet.YM

flush(stderr()); flush(stdout())

### Name: wavelet_YM
### Title: Meyer wavelet function, Fourier domain.
### Aliases: wavelet_YM
### Keywords: internal

### ** Examples

wavelet_YM(5,10,3)



### * <FOOTER>
###
cat("Time elapsed: ", proc.time() - get("ptime", env = .CheckExEnv),"\n")
grDevices::dev.off()
###
### Local variables: ***
### mode: outline-minor ***
### outline-regexp: "\\(> \\)?### [*]+" ***
### End: ***
quit('no')
