% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_supported_countries.R
\name{list_supported_countries}
\alias{list_supported_countries}
\title{List all supported countries and regions from the World Bank API}
\usage{
list_supported_countries(language = "en", per_page = 1000)
}
\arguments{
\item{language}{A character string specifying the language for the request, see \link{list_supported_languages}. Defaults to \code{"en"}.}

\item{per_page}{An integer specifying the number of results per page for the API. Defaults to 1000.
Must be a value between 1 and 32,500.}
}
\value{
A tibble containing country information along with associated metadata. The tibble includes the following columns:
\describe{
\item{id}{The identifier for the country.}
\item{iso2_code}{The ISO 2-character country code.}
\item{name}{The full name of the country.}
\item{capital_city}{The capital city of the country.}
\item{longitude}{The longitude of the country.}
\item{latitude}{The latitude of the country.}
\item{regions}{A nested tibble containing information about the region the country belongs to.}
\item{admin_regions}{A nested tibble containing information about the administrative region the country belongs to.}
\item{income_levels}{A nested tibble containing information about the income level classification of the country.}
\item{lending_types}{A nested tibble containing information about the lending type classification of the country.}
}
}
\description{
This function retrieves and processes a list of all countries supported by the World Bank API,
along with metadata such as region, administrative region, income level, and lending type.
The user can specify the language of the API response.
}
\details{
This function sends a request to the World Bank API to retrieve data for all supported countries
in the specified language. The data is then processed into a tidy format and includes information about the
country, such as its ISO code, capital city, geographical coordinates, and additional nested metadata about
regions, income levels, and lending types.
}
\examples{
# List all supported countries in English
list_supported_countries(language = "en")

# List all supported countries in Spanish
list_supported_countries(language = "zh")

}
