% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rewire.R
\name{dprewire.range}
\alias{dprewire.range}
\title{Range of assortativity coefficient.}
\usage{
dprewire.range(
  edgelist = NULL,
  directed = TRUE,
  adj = NULL,
  which.range = c("outout", "outin", "inout", "inin"),
  control = cvxr.control(),
  target.assortcoef = list(outout = NULL, outin = NULL, inout = NULL, inin = NULL)
)
}
\arguments{
\item{edgelist}{A two column matrix, each row represents an edge of the
network.}

\item{directed}{Logical, whether the network is directed or not.}

\item{adj}{Adjacency matrix of an unweighted network. It will be ignored if
\code{edgelist} is provided.}

\item{which.range}{The type of interested assortativity coefficient. For
directed networks, it takes one of the values: "outout", "outin", "inout"
and "inin". It will be ignored if the network is undirected.}

\item{control}{A list of parameters passed to \code{CVXR::solve()} for
solving an appropriate \code{eta} with the constraints 
\code{target.assortcoef}.}

\item{target.assortcoef}{A list of constraints, it has the predetermined 
value or range imposed on assortativity coefficients other than
\code{which.range}. It will be ignored if the network is undirected.}
}
\value{
Range of the interested assortativity coefficient and solver results.
}
\description{
The assortativity coefficient of a given network may not achieve all the
values within -1 and 1 via degree preserving rewiring. This function computes
the range of assortativity coefficients that can be achieved through degree
preserving rewiring. The algorithm is designed for unweighted networks.
}
\details{
The ranges are computed through convex optimization. The problems are defined
and solved via the \code{R} package \code{CVXR}. For undirected networks, the
function returns the range of the assortativity coefficient. For directed
networks, the function computes the range of \code{which.range} while other
assortativity coefficients are restricted through \code{target.assortcoef}.
}
\examples{
\donttest{
set.seed(123)
edgelist <- rpanet(5e3, control =
        rpactl.scenario(alpha = 0.5, beta = 0.5))$edgelist
ret1 <- dprewire.range(edgelist, directed = TRUE, which.range = "outin",
        target.assortcoef = list("outout" = c(-0.3, 0.3), "inout" = 0.1))
ret1$range
}

}
