% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joint_dist.R
\name{get_eta_undirected}
\alias{get_eta_undirected}
\title{Compute edge-level distribution for undirected networks with respect to
desired assortativity level.}
\usage{
get_eta_undirected(
  edgelist,
  target.assortcoef = NULL,
  eta.obj = function(x) 0,
  control = cvxr_control()
)
}
\arguments{
\item{edgelist}{A two column matrix representing the undirected edges of a
network.}

\item{target.assortcoef}{Numeric, represents the predetermined assortativity
coefficient. If \code{NA}, the range of assortativity coefficient and
corresponding joint distribution are returned.}

\item{eta.obj}{A convex function of \code{eta} to be minimized when
\code{target.assortcoef} is not \code{NA}. Defaults to 0.}

\item{control}{A list of parameters passed to \code{CVXR::solve()} when
solving for \code{eta} or computing the range of assortativity coefficient.}
}
\value{
Assortativity level and corresponding edge-level distribution.
}
\description{
Compute edge-level distribution for undirected networks with respect to
desired assortativity level.
}
\keyword{internal}
