% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assortativity.R
\name{dw_feature_assort}
\alias{dw_feature_assort}
\title{Feature based assortativity coefficient}
\usage{
dw_feature_assort(netwk, f1, f2)
}
\arguments{
\item{netwk}{A \code{wdnet} object that represents the network.}

\item{f1}{A vector, represents the first feature of existing nodes. Number of
nodes \code{= length(f1) = length(f2)}. Defined for directed networks. If
\code{NULL}, out-strength will be used.}

\item{f2}{A vector, represents the second feature of existing nodes. Defined
for directed networks. If \code{NULL}, in-strength will be used.}
}
\value{
Directed weighted assortativity coefficients between source nodes'
  \code{f1} (or \code{f2}) and target nodes' \code{f2}(or \code{f1}).
}
\description{
Node feature based assortativity coefficients for weighted and directed
networks.
}
\examples{
set.seed(123)
adj <- matrix(rbinom(400, 1, 0.2) * sample(1:3, 400, replace = TRUE), 20, 20)
f1 <- runif(20)
f2 <- abs(rnorm(20))
ret <- assortcoef(adj = adj, f1 = f1, f2 = f2)

}
\keyword{internal}
