% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_layer_functions.R
\name{get_fmdb_site_layer}
\alias{get_fmdb_site_layer}
\title{Retrieve WDNR's FMDB Site spatial layer}
\usage{
get_fmdb_site_layer(
  county = NULL,
  watershed_code = NULL,
  watershed_name = NULL,
  sf_object = NULL,
  site_seq = NULL,
  swims_site_seq = NULL,
  where = NULL,
  layer_type = "points",
  ...
)
}
\arguments{
\item{county}{A character object specifying a county name}

\item{watershed_code}{A character object specifying the HUC code for a
watershed}

\item{watershed_name}{A character object specifying the HUC name for a
watershed}

\item{sf_object}{Any sf object}

\item{site_seq}{A character object or string}

\item{swims_site_seq}{A character object or string}

\item{where}{A SQL statement}

\item{layer_type}{Character. Retrieve point stations, polygon stations, or
both.}

\item{...}{Additional parameters to pass to
\code{\link[arcpullr]{get_spatial_layer}}}
}
\value{
A sf object of class multipoints
}
\description{
A function that can be used to retrieve the WDNR's Fish Management Database's
(FMDB) monitoring site spatial layer.
A spatial query can be performed to limit the output of the function by
supplying a county name, watershed code, watershed name, or custom sf polygon
object. Use the 'watershed_lookup' to find valid watershed codes and names.
FMDB site sequance numbers (site_seq) or SWIMS (swims_site_seq) site sequance
numbers can be provided to return specific sites. The 'where'
arguement can be used to run custom SQL queries.
}
\examples{
\dontrun{
get_fmdb_site_layer(county = "milwaukee")
get_fmdb_site_layer(watershed_code = "07070006")
get_fmdb_site_layer(site_seq = c(7511,10175131,128290))
get_fmdb_site_layer(county = "waukesha",
                    where = "STATION_TYPE_CODE = 'LAKE'")
}
}
