% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dpird_apsim.R
\encoding{UTF-8}
\name{get_dpird_apsim}
\alias{get_dpird_apsim}
\title{Get DPIRD Summary Weather Data in the APSIM Format From the Weather 2.0 API}
\usage{
get_dpird_apsim(
  station_code,
  start_date,
  end_date = Sys.Date(),
  api_key = get_key(service = "DPIRD")
)
}
\arguments{
\item{station_code}{A \code{character} string or \code{factor} from
\code{\link[=get_stations_metadata]{get_stations_metadata()}} of the \acronym{BOM} station code for the station
of interest.}

\item{start_date}{A \code{character} string or \code{Date} object representing the
beginning of the range to query in the format \dQuote{yyyy-mm-dd}
(ISO8601).  Data returned is inclusive of this date.}

\item{end_date}{A \code{character} string or \code{Date} object representing the end of
the range query in the format  \dQuote{yyyy-mm-dd} (ISO8601).  Data
returned is inclusive of this date.  Defaults to the current system date.}

\item{api_key}{A \code{character} string containing your \acronym{API} key from
\acronym{DPIRD}, \url{https://www.agric.wa.gov.au/web-apis}, for the
\acronym{DPIRD} Weather 2.0 \acronym{API}.  Defaults to automatically
detecting your key from your local .Renviron, .Rprofile or similar.
Alternatively, you may directly provide your key as a string here.  If
nothing is provided, you will be prompted on how to set up your \R session
so that it is auto-detected.}
}
\value{
An \CRANpkg{apsimx} object of class \sQuote{met} with attributes.
}
\description{
Automates the retrieval and conversion of summary data from the
\acronym{DPIRD} Weather 2.0 \acronym{API} to an \acronym{APSIM} .met file
formatted weather data object.
}
\section{Saving objects}{

To save \dQuote{met} objects the \code{\link[apsimx:write_apsim_met]{apsimx::write_apsim_met()}} is reexported.
Note that when saving, comments from SILO will be included, but these will
not be printed as a part of the resulting \code{met} object in your \R session.
}

\examples{
\dontrun{
# Get an APSIM format object for Binnu
# Note that you need to supply your own API key

wd <- get_dpird_apsim(
  station_code = "BI",
  start_date = "20220101",
  end_date = "20221231",
  api_key = "your_api_key"
)
}


}
\seealso{
Other DPIRD: 
\code{\link{dpird_extreme_weather_values}},
\code{\link{dpird_minute_values}},
\code{\link{dpird_summary_values}},
\code{\link{find_nearby_stations}()},
\code{\link{find_stations_in}()},
\code{\link{get_dpird_availability}()},
\code{\link{get_dpird_extremes}()},
\code{\link{get_dpird_minute}()},
\code{\link{get_dpird_summaries}()},
\code{\link{get_stations_metadata}()}

Other data fetching: 
\code{\link{get_ag_bulletin}()},
\code{\link{get_coastal_forecast}()},
\code{\link{get_data_drill}()},
\code{\link{get_data_drill_apsim}()},
\code{\link{get_dpird_extremes}()},
\code{\link{get_dpird_minute}()},
\code{\link{get_dpird_summaries}()},
\code{\link{get_patched_point}()},
\code{\link{get_patched_point_apsim}()},
\code{\link{get_precis_forecast}()},
\code{\link{get_radar_imagery}()},
\code{\link{get_satellite_imagery}()}

Other APSIM: 
\code{\link{get_data_drill_apsim}()},
\code{\link{get_patched_point_apsim}()},
\code{\link{reexports}}
}
\author{
Adam H. Sparks, \email{adamhsparks@gmail.com}
}
\concept{APSIM}
\concept{DPIRD}
\concept{data fetching}
