% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.SDMfit.R
\name{print.SDMfit}
\alias{print.SDMfit}
\title{Prints a SDMfit object}
\usage{
\method{print}{SDMfit}(x, ...)
}
\arguments{
\item{x}{A SDMfit object, typically obtained with trophicSDM() and available in the field $model of a trophicSDMfit object}

\item{...}{additional arguments}
}
\value{
Prints a summary of the local SDM
}
\description{
Prints a SDMfit object
}
\examples{
data(Y, X, G)
# define abiotic part of the model
env.formula = "~ X_1 + X_2"
# Run the model with bottom-up control using stan_glm as fitting method and no penalisation
# (set iter = 1000 to obtain reliable results)
m = trophicSDM(Y, X, G, env.formula, iter = 100,
               family = binomial(link = "logit"), penal = NULL, 
               mode = "prey", method = "stan_glm")
m$model$Y1
}
\author{
Giovanni Poggiato
}
