% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/etox.R
\name{etox_targets}
\alias{etox_targets}
\title{Get Quality Targets from a ETOX ID}
\usage{
etox_targets(id, verbose = TRUE)
}
\arguments{
\item{id}{character; ETOX ID}

\item{verbose}{logical; print message during processing to console?}
}
\value{
A list of two: \code{res} a data.frame with quality targets from the ETOX database, and source_url.
}
\description{
Query ETOX: Information System Ecotoxicology and Environmental Quality Targets
\url{https://webetox.uba.de/webETOX/index.do} for quality targets
}
\note{
Before using this function, please read the disclaimer
\url{https://webetox.uba.de/webETOX/disclaimer.do}.
}
\examples{
\dontrun{
id <- get_etoxid('Triclosan', mult = 'best')
out <- etox_targets(id)
out[ , c('Substance', 'CAS_NO', 'Country_or_Region', 'Designation',
'Value_Target_LR', 'Unit')]
# Retrieve MAC-EQA for Germany for multiple inputs
ids <- c("20179", "9051")
sapply(ids, function(y) {
  res <- etox_targets(y)
  if (length(res) == 1) {
    out <- res
  } else {
    out <- res[res$Country_or_Region == 'DEU' & res$Designation == 'MAC-EQS', c('Value_Target_LR')]
  }
  return(out)
}
)
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
\seealso{
\code{\link{get_etoxid}} to retrieve ETOX IDs, \code{\link{etox_basic}} for basic information,
\code{\link{etox_targets}} for quality targets and \code{\link{etox_tests}} for test results
}

