% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppdb.R
\name{ppdb_query}
\alias{ppdb_query}
\title{Query the ppdb for information}
\usage{
ppdb_query(cas, verbose = TRUE, index = NULL)
}
\arguments{
\item{cas}{character; CAS number to query.}

\item{verbose}{logical; print message during processing to console?}

\item{index}{A index object, as created by \code{\link{ppdb_buildidx}}.
If NULL (default), the index shipped with webchem is used \code{\link{ppdb_idx}}.}
}
\value{
A list of 11 data.frames : ec_regulation, approved_in, general, parents, fate,
deg, soil, metab, etox, names and source_url.

See also \url{http://sitem.herts.ac.uk/aeru/iupac/docs/Background_and_Support.pdf} for more information on the data
}
\description{
This function queries the PPDB \url{http://sitem.herts.ac.uk/aeru/iupac/search.htm} for information.
}
\note{
Please read the Terms and Conditions for use: \url{http://sitem.herts.ac.uk/aeru/ppdb/en/docs/Conditions_of_use.pdf}.
}
\examples{
\dontrun{
# might fail if Server is not available
gly <- ppdb_query('1071-83-6')
gly$approved_in

# handle multiple CAS
 cas <- c('1071-83-6', '50-00-0')
 # check if these compounds are approved in germany
 foo <- function(y) {
   # query cas
   q <- ppdb_query(y)
   # extract status for germany
   q$approved_in$status[q$approved_in$country == 'DE']
 }
 sapply(cas, foo)
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
\references{
Lewis, Kathleen A., John Tzilivakis, Douglas J. Warner, and Andrew Green 2016.
An International Database for Pesticide Risk Assessments and Management. Human and Ecological Risk Assessment: An International Journal
}

