% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemspider.R
\name{cs_inchi_mol}
\alias{cs_inchi_mol}
\title{Convert a InChI to Molfile}
\usage{
cs_inchi_mol(inchi, parse = TRUE, verbose = TRUE, ...)
}
\arguments{
\item{inchi}{character,  InChI}

\item{parse}{should the molfile be parsed to a R object?
If \code{FALSE} the raw mol is returned as string.}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{...}{currently not used.}
}
\value{
If parse = FALSE then a charactersting,
  else a RMol-object (from \code{\link{parse_mol}})
}
\description{
Convert a InChI to Molfile
}
\examples{
\donttest{
# might fail if API is not available
inchi <-  paste0("InChI=1S/C17H19NO3/c1-18-7-6-17-10-3-5-13(20)16(17)21-15-12(19)4-",
"2-9(14(15)17)8-11(10)18/h2-5,10-11,13,16,19-20H,6-8H2,1H3/t10-,11+,13-,16-,17-/m0/s1")
# convert InChI to CSID
cs_inchi_mol(inchi)
cs_inchi_mol(inchi, parse = FALSE)
}
}
\seealso{
This is a low level function. Please see \code{\link{cs_convert}} for the top level function.
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
