% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pubchem.R
\name{get_cid}
\alias{get_cid}
\title{Retrieve Pubchem Id (CID)}
\usage{
get_cid(query, from = "name", first = FALSE, verbose = TRUE, arg = NULL,
  ...)
}
\arguments{
\item{query}{character; search term.}

\item{from}{character; type of input, can be one of 'name' (default), 'cid', 'sid', 'aid', 'smiles', 'inchi', 'inchikey'}

\item{first}{logical; If TRUE return only first result.}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{arg}{character; optinal arguments like 'name_type=word' to match individual words.}

\item{...}{optional arguments}
}
\value{
a list of cids. If first = TRUE a vector.
}
\description{
Return CompoundID (CID) for a search query using PUG-REST,
see \url{https://pubchem.ncbi.nlm.nih.gov/}.
}
\examples{
\donttest{
# might fail if API is not available
get_cid('Triclosan')
get_cid('Triclosan', arg = 'name_type=word')
get_cid("BPGDAMSIGCZZLK-UHFFFAOYSA-N", from = 'inchikey')
get_cid("CCCC", from = 'smiles')

# multiple inputs
comp <- c('Triclosan', 'Aspirin')
get_cid(comp)

}
}
\references{
Wang, Y., J. Xiao, T. O. Suzek, et al. 2009 PubChem: A Public Information System for
Analyzing Bioactivities of Small Molecules. Nucleic Acids Research 37: 623–633.

Kim, Sunghwan, Paul A. Thiessen, Evan E. Bolton, et al. 2016
PubChem Substance and Compound Databases. Nucleic Acids Research 44(D1): D1202–D1213.

Kim, S., Thiessen, P. A., Bolton, E. E., & Bryant, S. H. (2015).
PUG-SOAP and PUG-REST: web services for programmatic access to chemical information in PubChem. Nucleic acids research, gkv396.
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
