% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cir.R
\name{cir_img}
\alias{cir_img}
\title{Query Chemical Identifier Resolver Images}
\usage{
cir_img(
  query,
  dir,
  format = c("png", "gif"),
  width = 500,
  height = 500,
  linewidth = 2,
  symbolfontsize = 16,
  bgcolor = NULL,
  antialiasing = TRUE,
  atomcolor = NULL,
  bondcolor = NULL,
  csymbol = c("special", "all"),
  hsymbol = c("special", "all"),
  hcolor = NULL,
  header = NULL,
  footer = NULL,
  frame = NULL,
  verbose = getOption("verbose"),
  ...
)
}
\arguments{
\item{query}{character; Search term. Can be any common chemical identifier
(e.g. CAS, INCHI(KEY), SMILES etc.)}

\item{dir}{character; Directory to save the image.}

\item{format}{character; Output format of the image. Can be one of "png",
"gif".}

\item{width}{integer; Width of the image.}

\item{height}{integer; Height of the image.}

\item{linewidth}{integer; Width of lines.}

\item{symbolfontsize}{integer; Fontsize of atoms in the image.}

\item{bgcolor}{character; E.g. transparent, white, \%23AADDEE}

\item{antialiasing}{logical; Should antialiasing be used?}

\item{atomcolor}{character; Color of the atoms in the image.}

\item{bondcolor}{character; Color of the atom bond lines.}

\item{csymbol}{character; Can be one of "special" (default - i.e. only
hydrogen atoms in functional groups or defining stereochemistry) or "all".}

\item{hsymbol}{character; Can be one of "special" (default - i.e. none are
shown) or "all" (all are printed).}

\item{hcolor}{character; Color of the hydrogen atoms.}

\item{header}{character; Should a header text be added to the image? Can be
any string.}

\item{footer}{character; Should a footer text be added to the image? Can be
any string.}

\item{frame}{integer; Should a frame be plotted? Can be on of NULL (default)
or 1.}

\item{verbose}{logical; Should a verbose output be printed on the console?}

\item{...}{currently not used.}
}
\value{
image written to disk
}
\description{
A interface to the Chemical Identifier Resolver (CIR).
 (\url{https://cactus.nci.nih.gov/chemical/structure_documentation}).
}
\details{
CIR can resolve can be of the following \code{identifier}: Chemical Names,
 IUPAC names,
 CAS Numbers, SMILES strings, IUPAC InChI/InChIKeys, NCI/CADD Identifiers,
 CACTVS HASHISY, NSC number, PubChem SID, ZINC Code, ChemSpider ID,
 ChemNavigator SID, eMolecule VID.

 For an image with transparent background use ‘transparent’ as color name and
 switch off antialiasing (i.e. antialiasing = 0).
}
\note{
You can only make 1 request per second (this is a hard-coded feature).
}
\examples{
\donttest{
# might fail if API is not available
cir_img("CCO", dir = tempdir()) # SMILES

# multiple query strings and different formats
query = c("Glyphosate", "Isoproturon", "BSYNRYMUTXBXSQ-UHFFFAOYSA-N")
cir_img(query, dir = tempdir(), bgcolor = "transparent", antialising = 0)

# all parameters
query  = "Triclosan"
cir_img(query,
        dir = tempdir(),
        format = "png",
        width = 600,
        height = 600,
        linewidth = 5,
        symbolfontsize = 30,
        bgcolor = "red",
        antialiasing = FALSE,
        atomcolor = "green",
        bondcolor = "yellow",
        csymbol = "all",
        hsymbol = "all",
        hcolor = "purple",
        header = "My funky chemical structure..",
        footer = "..is just so awesome!",
        frame = 1,
        verbose = getOption("verbose"))
}
}
\references{
\code{cir} relies on the great CIR web service created by the CADD
Group at NCI/NIH! \cr
\url{https://cactus.nci.nih.gov/chemical/structure_documentation}, \cr
\url{https://cactus.nci.nih.gov/blog/?cat=10}, \cr
\url{https://cactus.nci.nih.gov/blog/?p=1386}, \cr
\url{https://cactus.nci.nih.gov/blog/?p=1456}, \cr
}
