% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop.R
\name{crop_tem}
\alias{crop_tem}
\title{Crop to template boundaries and pad}
\usage{
crop_tem(
  stimuli,
  top = 10,
  right = top,
  bottom = top,
  left = right,
  each = FALSE,
  ...
)
}
\arguments{
\item{stimuli}{list of stimuli}

\item{top, right, bottom, left}{numeric; number of pixels or proportion (<1) to pad each side}

\item{each}{logical; Whether to calculate bounds for the full set (default) or each image separately}

\item{...}{additional arguments to pass to \code{\link[=crop]{crop()}}}
}
\value{
list of stimuli
}
\description{
Calculate the maximum and minimum x and y coordinates across the stimuli (or for each stimulus) and crop all image to this plus padding.
}
\examples{
stimuli <- demo_stim()
ctem <- crop_tem(stimuli, each = TRUE)
draw_tem(ctem)

\donttest{
# demo with different templates
stimuli <- demo_tems()

# default 10 pixels around maximum template
crop_tem(stimuli) 

# crop specific to each image
crop_tem(stimuli, each = TRUE)
}

}
\seealso{
Stimulus manipulation functions
\code{\link{align}()},
\code{\link{crop}()},
\code{\link{greyscale}()},
\code{\link{horiz_eyes}()},
\code{\link{image_func}()},
\code{\link{mask_oval}()},
\code{\link{mask}()},
\code{\link{mirror}()},
\code{\link{pad}()},
\code{\link{resize}()},
\code{\link{rotate}()},
\code{\link{to_size}()}
}
\concept{manipulators}
