% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{resize}
\alias{resize}
\title{Resize an image}
\usage{
resize(filename, geometry)
}
\arguments{
\item{filename}{Name of image to resize.}

\item{geometry}{Scaling specification. Can be a percent, as in \code{"50\%"},
or pixel dimensions like \code{"120x120"}, \code{"120x"}, or \code{"x120"}.
Any valid ImageMagick geometry specifation can be used.}
}
\description{
This does not change size of the image in pixels, nor does it affect
appearance -- it is lossless compression. This requires GraphicsMagick
(recommended) or ImageMagick to be installed.
}
\examples{
if (interactive()) {
  # Can be chained with webshot() or appshot()
  webshot("http://www.google.com/", "google-small-1.png") \%>\%
    resize("75\%")

  # Generate image that is 400 pixels wide
  webshot("http://www.google.com/", "google-small-2.png") \%>\%
    resize("400x")
}
}

