% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{add_duration}
\alias{add_duration}
\title{Add time spent in seconds on webpage}
\usage{
add_duration(wt, reset = 3600)
}
\arguments{
\item{wt}{webtrack data object}

\item{reset}{numeric. If duration is greater than this value, it is reset to zero, assuming a new browsing session has started}
}
\value{
webtrack data.table with the same columns as wt and a new column called duration
}
\description{
Derive the time spend on a website from the timestamps
}
\examples{
data("test_data")
wt <- as.wt_dt(test_data)
wt <- add_duration(wt)
}
