% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wbb_pbp.R
\name{load_wbb_player_box}
\alias{load_wbb_player_box}
\title{\strong{Load wehoop women's college basketball player box scores}}
\usage{
load_wbb_player_box(
  seasons = most_recent_wbb_season(),
  ...,
  dbConnection = NULL,
  tablename = NULL
)
}
\arguments{
\item{seasons}{A vector of 4-digit years associated with given women's college basketball seasons. (Min: 2006)}

\item{...}{Additional arguments passed to an underlying function that writes
the season data into a database (used by \code{update_wbb_db()}).}

\item{dbConnection}{A \code{DBIConnection} object, as returned by \code{\link[DBI:dbConnect]{DBI::dbConnect()}}}

\item{tablename}{The name of the play by play data table within the database}
}
\value{
Returns a tibble
}
\description{
helper that loads multiple seasons from the data repo either into memory
or writes it into a db using some forwarded arguments in the dots
}
\examples{
\donttest{
load_wbb_player_box(2021)
}
}
