% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_lineups.R
\name{wnba_leagueseasonmatchups}
\alias{wnba_leagueseasonmatchups}
\title{\strong{Get WNBA Stats API League Season Matchups}}
\usage{
wnba_leagueseasonmatchups(
  def_player_id = "",
  def_team_id = "",
  league_id = "10",
  off_player_id = "",
  off_team_id = "",
  per_mode = "Totals",
  season = most_recent_wnba_season() - 1,
  season_type = "Regular Season",
  ...
)
}
\arguments{
\item{def_player_id}{def_player_id}

\item{def_team_id}{def_team_id}

\item{league_id}{league_id}

\item{off_player_id}{off_player_id}

\item{off_team_id}{off_team_id}

\item{per_mode}{per_mode}

\item{season}{season}

\item{season_type}{season_type}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: SeasonMatchups

\strong{SeasonMatchups}\tabular{ll}{
   col_name \tab types \cr
   SEASON_ID \tab character \cr
   OFF_PLAYER_ID \tab character \cr
   OFF_PLAYER_NAME \tab character \cr
   DEF_PLAYER_ID \tab character \cr
   DEF_PLAYER_NAME \tab character \cr
   GP \tab character \cr
   MATCHUP_MIN \tab character \cr
   PARTIAL_POSS \tab character \cr
   PLAYER_PTS \tab character \cr
   TEAM_PTS \tab character \cr
   MATCHUP_AST \tab character \cr
   MATCHUP_TOV \tab character \cr
   MATCHUP_BLK \tab character \cr
   MATCHUP_FGM \tab character \cr
   MATCHUP_FGA \tab character \cr
   MATCHUP_FG_PCT \tab character \cr
   MATCHUP_FG3M \tab character \cr
   MATCHUP_FG3A \tab character \cr
   MATCHUP_FG3_PCT \tab character \cr
   HELP_BLK \tab character \cr
   HELP_FGM \tab character \cr
   HELP_FGA \tab character \cr
   HELP_FG_PERC \tab character \cr
   MATCHUP_FTM \tab character \cr
   MATCHUP_FTA \tab character \cr
   SFL \tab character \cr
   MATCHUP_TIME_SEC \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API League Season Matchups}

\strong{Get WNBA Stats API League Season Matchups}
}
\details{
(No Matchups Data for WNBA yet, so defunct)

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ wnba_leagueseasonmatchups(league_id = '10', season = most_recent_wnba_season() - 1)
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA League Functions: 
\code{\link{wnba_leaguedashlineups}()},
\code{\link{wnba_leaguedashplayerbiostats}()},
\code{\link{wnba_leaguedashplayerclutch}()},
\code{\link{wnba_leaguedashplayershotlocations}()},
\code{\link{wnba_leaguedashplayerstats}()},
\code{\link{wnba_leaguedashteamclutch}()},
\code{\link{wnba_leaguedashteamshotlocations}()},
\code{\link{wnba_leaguedashteamstats}()},
\code{\link{wnba_leaguegamefinder}()},
\code{\link{wnba_leaguegamelog}()},
\code{\link{wnba_leaguelineupviz}()},
\code{\link{wnba_leagueplayerondetails}()},
\code{\link{wnba_leaguestandingsv3}()},
\code{\link{wnba_shotchartleaguewide}()}

Other WNBA Player Functions: 
\code{\link{wnba_infographicfanduelplayer}()},
\code{\link{wnba_leaguedashplayerbiostats}()},
\code{\link{wnba_leaguedashplayerclutch}()},
\code{\link{wnba_leaguedashplayershotlocations}()},
\code{\link{wnba_leaguedashplayerstats}()},
\code{\link{wnba_leagueplayerondetails}()},
\code{\link{wnba_playerawards}()},
\code{\link{wnba_playercareerbycollegerollup}()},
\code{\link{wnba_playercareerbycollege}()},
\code{\link{wnba_playercareerstats}()},
\code{\link{wnba_playercompare}()},
\code{\link{wnba_playerdashboardbyclutch}()},
\code{\link{wnba_playerdashboardbygamesplits}()},
\code{\link{wnba_playerdashboardbygeneralsplits}()},
\code{\link{wnba_playerdashboardbylastngames}()},
\code{\link{wnba_playerdashboardbyopponent}()},
\code{\link{wnba_playerdashboardbyshootingsplits}()},
\code{\link{wnba_playerdashboardbyteamperformance}()},
\code{\link{wnba_playerdashboardbyyearoveryear}()},
\code{\link{wnba_playerestimatedmetrics}()},
\code{\link{wnba_playerfantasyprofilebargraph}()},
\code{\link{wnba_playerfantasyprofile}()},
\code{\link{wnba_playergamelogs}()},
\code{\link{wnba_playergamelog}()},
\code{\link{wnba_playergamestreakfinder}()},
\code{\link{wnba_playerheadshot}()},
\code{\link{wnba_playerindex}()},
\code{\link{wnba_playernextngames}()},
\code{\link{wnba_playerprofilev2}()},
\code{\link{wnba_playervsplayer}()}
}
\author{
Saiem Gilani
}
\concept{WNBA League Functions}
\concept{WNBA Player Functions}
