% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/wkt2geojson.R
\name{wkt2geojson}
\alias{wkt2geojson}
\title{Convert WKT to GeoJSON-like objects.}
\usage{
wkt2geojson(str, fmt = 16, feature = TRUE)
}
\arguments{
\item{str}{A GeoJSON-like object representing a Point, LineString, Polygon, MultiPolygon, etc.}

\item{fmt}{Number of digits to display after the decimal point when formatting
coordinates.}

\item{feature}{(logical) Make a feature geojson object. Default: TRUE}
}
\description{
Convert WKT to GeoJSON-like objects.
}
\details{
Should be robust against a variety of typing errors, including extra spaces between
coordinates, no space between WKT type and coordinates. However, some things won't pass,
includingn lowercase WKT types, no spaces between coordinates.
}
\examples{
# point
str <- "POINT (-116.4000000000000057 45.2000000000000028)"
wkt2geojson(str)
wkt2geojson(str, feature=FALSE)

# multipoint
str <- 'MULTIPOINT ((100.000 3.101), (101.000 2.100), (3.140 2.180))'
wkt2geojson(str, fmt = 2)
wkt2geojson(str, fmt = 2, feature=FALSE)

# polygon
str <- "POLYGON ((100 0.1, 101.1 0.3, 101 0.5, 100 0.1),
   (103.2 0.2, 104.8 0.2, 100.8 0.8, 103.2 0.2))"
wkt2geojson(str)
wkt2geojson(str, feature=FALSE)

# multipolygon
str <- "MULTIPOLYGON (((40 40, 20 45, 45 30, 40 40)),
   ((20 35, 45 20, 30 5, 10 10, 10 30, 20 35), (30 20, 20 25, 20 15, 30 20)))"
wkt2geojson(str)
wkt2geojson(str, feature=FALSE)

# linestring
str <- "LINESTRING (100.000 0.000, 101.000 1.000)"
wkt2geojson(str)
wkt2geojson(str, feature=FALSE)
wkt2geojson("LINESTRING (0 -1, -2 -3, -4 5)")
wkt2geojson("LINESTRING (0 1 2 3, 4 5 6 7)")

# multilinestring
str <- "MULTILINESTRING ((30 1, 40 30, 50 20)(10 0, 20 1))"
wkt2geojson(str)

str <- "MULTILINESTRING (
   (-105.0 39.5, -105.0 39.5, -105.0 39.5, -105.0 39.5, -105.0 39.5, -105.0 39.5),
   (-105.0 39.5, -105.0 39.5, -105.0 39.5),
   (-105.0 39.5, -105.0 39.5, -105.0 39.5, -105.0 39.5, -105.0 39.5),
   (-105.0 39.5, -105.0 39.5, -105.0 39.5, -105.0 39.5))"
wkt2geojson(str)

# Geometrycollection
str <- "GEOMETRYCOLLECTION (
   POINT (0 1),
   LINESTRING (-100 0, -101 -1),
   POLYGON ((100.001 0.001, 101.1235 0.0010, 101.001 1.001, 100.001 0.001),
           (100.201 0.201, 100.801 0.201, 100.801 0.801, 100.201 0.201)),
   MULTIPOINT ((100.000 3.101), (101.0 2.1), (3.14 2.18)),
   MULTILINESTRING ((0 -1, -2 -3, -4 -5),
                   (1.66 -31023.50 1.10, 10001.0 3.0 2.2, 100.9 1.1 3.3, 0.0 0.0 4.4)),
   MULTIPOLYGON (((100.001 0.001, 101.001 0.001, 101.001 1.001, 100.001 0.001),
                 (100.201 0.201, 100.801 0.201, 100.801 0.801, 100.201 0.201)),
                 ((1 2 3 4, 5 6 7 8, 9 10 11 12, 1 2 3 4))))"
wkt2geojson(str)
}
\seealso{
\code{\link{geojson2wkt}}
}

