% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{wbt_gaussian_scale_space}
\alias{wbt_gaussian_scale_space}
\title{Gaussian scale space}
\usage{
wbt_gaussian_scale_space(
  dem,
  output,
  output_zscore,
  output_scale,
  points = NULL,
  sigma = 0.5,
  step = 0.5,
  num_steps = 10,
  lsp = "Slope",
  z_factor = NULL,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE
)
}
\arguments{
\item{dem}{Name of the input DEM raster file.}

\item{output}{Name of the output land-surface parameter raster file.}

\item{output_zscore}{Name of the output z-score raster file.}

\item{output_scale}{Name of the output scale raster file.}

\item{points}{Name of the input vector points shapefile.}

\item{sigma}{Initial sigma value (cells).}

\item{step}{Step size as any positive non-zero integer.}

\item{num_steps}{Number of steps.}

\item{lsp}{Output land-surface parameter; one of 'AnisotropyLTP', 'Aspect', 'DiffMeanElev', 'Eastness', 'Elevation', 'Hillshade', 'MeanCurvature', 'Northness', 'PlanCurvature', 'ProfileCurvature', 'Ruggedness', 'Slope', 'TanCurvature', 'TotalCurvature'.}

\item{z_factor}{Optional multiplier for when the vertical and horizontal units are not the same.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is False, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}
}
\value{
Returns the tool text outputs.
}
\description{
This tool uses the fast Gaussian approximation algorithm to produce scaled land-surface parameter measurements from an input DEM.
}
