% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lidar_analysis.R
\name{wbt_colourize_based_on_point_returns}
\alias{wbt_colourize_based_on_point_returns}
\title{Colourize based on point returns}
\usage{
wbt_colourize_based_on_point_returns(
  input,
  output = NULL,
  intensity_blending = 50,
  only = "(230,214,170)",
  first = "(0,140,0)",
  intermediate = "(255,0,255)",
  last = "(0,0,255)",
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{input}{Name of the input LiDAR points.}

\item{output}{Name of the output LiDAR points.}

\item{intensity_blending}{Intensity blending amount (0-100 percent).}

\item{only}{Only return colour, e.g. (230,214,170), #e6d6aa, or 0xe6d6aa.}

\item{first}{First return colour, e.g. (230,214,170), #e6d6aa, or 0xe6d6aa.}

\item{intermediate}{Intermediate return colour, e.g. (230,214,170), #e6d6aa, or 0xe6d6aa.}

\item{last}{Last return colour, e.g. (230,214,170), #e6d6aa, or 0xe6d6aa.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Sets the RGB values of a LiDAR point cloud based on the point returns.
}
