% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_USGS.R
\name{ww_wyUSGS}
\alias{ww_wyUSGS}
\title{Water Year Stats (USGS)}
\usage{
ww_wyUSGS(procDV, sites = NULL, parallel = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{procDV}{A previously created \link[whitewater]{ww_dvUSGS} object.}

\item{sites}{A \code{character} vector with NWIS site numbers (optional).}

\item{parallel}{\code{logical} indicating whether to use future_map().}

\item{verbose}{\code{logical} for printing information. TRUE (default).}

\item{...}{arguments to pass on to \link[furrr]{future_map} and/or \link[whitewater]{ww_dvUSGS}.}
}
\value{
A \code{tibble} filtered by water year with added meta-data.
}
\description{
This function uses the results of the \link[whitewater]{ww_dvUSGS} object to
generate mean, maximum, median, standard deviation and some normalization methods (drainage
area, scaled by log and standard deviation) per water year.
}
\note{
If a previously created \link[whitewater]{ww_dvUSGS} object is not used then the user needs to
provide a \code{sites} vector. This will run \link[whitewater]{ww_dvUSGS} in the background.
}
\examples{
\dontrun{

library(whitewater)
yaak_river_dv <- ww_dvUSGS('12304500',
parameter_cd = '00060',
wy_month = 10)

yaak_river_wy <- ww_wyUSGS(yaak_river_dv)

#parallel

#get sites

huc17_sites <- dataRetrieval::whatNWISdata(huc = 17,
siteStatus = 'active',
service = 'dv',
parameterCd = '00060')

library(future)
#need to call future::plan()
plan(multisession(workers = availableCores()-1))

pnw_dv <- ww_dvUSGS(huc17_sites$site_no,
parameter_cd = '00060',
wy_month = 10,
parallel = TRUE)

pnw_wy <- ww_wyUSGS(pnw_dv,
                    parallel = TRUE)
}

}
