% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasch_split_age.R
\name{rasch_split_age}
\alias{rasch_split_age}
\title{Split all survey items by age category for a Rasch Model if they are not discrete}
\usage{
rasch_split_age(df, vars_group, vars_metric, vars_id, max_values)
}
\arguments{
\item{df}{a data frame of individual survey data, where each row is an individual}

\item{vars_group}{a string with the column name identifying grouping variable}

\item{vars_metric}{a character vector of items to use in the Rasch Analysis}

\item{vars_id}{a string with column name uniquely identifying individuals}

\item{max_values}{a tibble with two columns, \code{var} equivalent to \code{vars_metric} and \code{max_val} with their corresponding maximum possible values}
}
\value{
a named list with:
\item{df}{new \code{df} after splitting the variables}
\item{vars_metric}{new \code{vars_metric} after splitting the variables}
\item{max_values}{new \code{max_values} after splitting the variables}
}
\description{
Split all survey items by age category for a Rasch Model if they are not discrete
}
\seealso{
Other rasch functions: 
\code{\link{rasch_DIF}()},
\code{\link{rasch_df_nest}()},
\code{\link{rasch_drop}()},
\code{\link{rasch_factor}()},
\code{\link{rasch_mds_children}()},
\code{\link{rasch_mds}()},
\code{\link{rasch_model_children}()},
\code{\link{rasch_model}()},
\code{\link{rasch_quality_children_print}()},
\code{\link{rasch_quality_children}()},
\code{\link{rasch_rawscore}()},
\code{\link{rasch_recode}()},
\code{\link{rasch_rescale_children}()},
\code{\link{rasch_rescale}()},
\code{\link{rasch_split}()},
\code{\link{rasch_testlet}()}

Other children analysis functions: 
\code{\link{rasch_df_nest}()},
\code{\link{rasch_drop}()},
\code{\link{rasch_mds_children}()},
\code{\link{rasch_model_children}()},
\code{\link{rasch_quality_children_print}()},
\code{\link{rasch_quality_children}()},
\code{\link{rasch_recode}()},
\code{\link{rasch_rescale_children}()},
\code{\link{rasch_split}()},
\code{\link{rasch_testlet}()}
}
\concept{children analysis functions}
\concept{rasch functions}
