% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{w_isInstanceOf}
\alias{w_isInstanceOf}
\title{Check if a Wikidata entity is an instance of a class}
\usage{
w_isInstanceOf(entity_list, instanceof)
}
\arguments{
\item{entity_list}{A vector with de Wikidata entities.}

\item{instanceof}{The Wikidata class to check, mandatory.}
}
\value{
A data-frame with two columns, first Wikidata entity, second TRUE
if that entity is instance of the "instanceof" entity, else FALSE. Index of
data-frame are also set to entity_list.
}
\description{
Check using WDQS if the Wikidata entities in entity_list are instances of
"instanceof" Wikidata entity class. For example, if instanceof="Q5", check if
entities are instances of the Wikidata entity class Q5, i.e, are humans.
Duplicated entities are deleted before search.
}
\examples{
# aux: get a vector of entities (l).
df <- w_SearchByLabel(string='Iranzo', langsorder='es|en', mode='inlabel')
l <- df$entity

df <- w_isInstanceOf(entity_list=l, instanceof='Q5')
# Not TRUE
df[!df$instanceof_Q5,]
}
\author{
Angel Zazo, Department of Computer Science and Automatics, University of Salamanca
}
