% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conContext.R
\name{conContext}
\alias{conContext}
\title{Examine context associated with contact phases}
\usage{
conContext(ltraj, var = "dist", def = "all", idcol = "burst",
  nrand = 0, nlag = 0, lag = 0, gap = 0, phaid)
}
\arguments{
\item{ltraj}{an object of the class \code{ltraj} which should be output from the function \code{conPhase}.}

\item{var}{name(s) (as character) of columns (possibly from \code{infolocs}) to keep for contextual analysis.}

\item{def}{how to define the point-of-contact. The default is to define it as all fixes in a phase \code{def = 'all'}, alternatively contacts can be defined as a single point along the phase defined as one of: \code{'first','last','minDist','minTime'}, which corresponds to the first fix int he contact phase, the last fix in the contact phase, the fix with the minimum time difference and the fix with the closest contact distance.}

\item{idcol}{column id associated with IDs of individuals, default is the 'burst'.}

\item{nrand}{number of random fixes to be selected (default = 0).}

\item{nlag}{number of lags to compute in the before and after phases of a contact. If lag = 0 then only contacts are used.}

\item{lag}{time (in seconds) for defining the lags in before and after periods of a contact.}

\item{gap}{time (in seconds) for excluding the lags in before and after periods of a contact.}

\item{phaid}{(optional) id(s) of the contact phase upon which to examine (default is all).}
}
\value{
A dataframe that can be used to examine behaviour/context before, during, and after contact phases.
}
\description{
Extracts the variables associated with \code{var} before, during, and after contact phases, based on some specified time-lag.
}
\details{
This function is used following the \code{conphase} function. One should choose how to define the contact point (i.e., the parameter \code{contact}) depending on the research question. In most typical cases (with regular interval tracking data) the lag time should be set to the tracking interval and the gap should be set to 1/2 the tracking interval.
}
\examples{

\dontrun{
data(does)
doecons <- conProcess(does,tc=15*60,dc=50)
doephas <- conPhase(doecons,pc=60*60)
cc <- conContext(var='dist',def='first',nlag=3,lag=30*60,gap=15*60)
head(cc)
}

}
\seealso{
conPhase
}
\keyword{contacts}
